/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.capability;

import com.google.common.base.Preconditions;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ItemHandlerCapabilitySource<Capability, Context> {
    private final ItemCapability<Capability, Context> _capability;
    private final IItemHandler _handler;
    private final int _slot;

    public ItemHandlerCapabilitySource(IItemHandler handler, int slot, ItemCapability<Capability, Context> capability) {
        Preconditions.checkNotNull(capability, (Object)"Capability must not be null");
        Preconditions.checkNotNull((Object)handler, (Object)"Handler must not be null");
        Preconditions.checkArgument((slot >= 0 ? 1 : 0) != 0, (Object)"Slot must greater or equal to zero");
        this._capability = capability;
        this._handler = handler;
        this._slot = slot;
    }

    @Nullable
    public Capability getCapability(@Nullable Context context) {
        return (Capability)this._handler.getStackInSlot(this._slot).getCapability(this._capability, context);
    }
}

