/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.functional.ComponentSupplier;
import it.zerono.mods.zerocore.lib.functional.StringSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class RichText
implements IRichText {
    public static final RichText EMPTY = new RichText();
    public static final int NO_MAX_WIDTH = -1;
    final List<TextLine> _lines;
    final Supplier<@NotNull Font> _fontSupplier;
    private Colour _textColour;
    private int _interline;
    private Rectangle _bounds;
    private final boolean _dynamic;

    public static Builder builder() {
        return new Builder(Integer.MAX_VALUE);
    }

    public static Builder builder(int maxWidth) {
        return maxWidth < 1 ? new Builder(Integer.MAX_VALUE) : new Builder(maxWidth);
    }

    @Override
    public void paint(GuiGraphics gfx, int x, int y, int zLevel) {
        PoseStack matrix = gfx.pose();
        matrix.pushPose();
        matrix.translate(0.0f, 0.0f, (float)zLevel);
        for (TextLine line : this._lines) {
            line.paint(this, gfx, x, y);
            y += line.getHeight() + this._interline;
        }
        matrix.popPose();
    }

    @Override
    public Rectangle bounds() {
        if (null == this._bounds || this._dynamic) {
            this._bounds = new Rectangle(0, 0, this._lines.stream().mapToInt(TextLine::getWidth).max().orElse(0), (this._lines.size() - 1) * this._interline + this._lines.stream().mapToInt(TextLine::getHeight).sum());
        }
        return this._bounds;
    }

    @Override
    public boolean isEmpty() {
        return this._lines.isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return !this._lines.isEmpty();
    }

    private RichText() {
        this(ModRenderHelper.DEFAULT_FONT_RENDERER, Collections.emptyList());
    }

    private RichText(Supplier<@NotNull Font> font, List<TextLine> lines) {
        this._lines = lines;
        this._fontSupplier = font;
        this._textColour = Colour.BLACK;
        this._interline = 0;
        this._bounds = null;
        this._dynamic = this._lines.stream().anyMatch(TextLine::isDynamic);
    }

    private static void paintString(RichText richText, String chunk, GuiGraphics gfx, int x, int y) {
        gfx.drawString(richText._fontSupplier.get(), chunk, x, y, richText._textColour.toARGB(), true);
    }

    private static void paintString(RichText richText, FormattedText chunk, GuiGraphics gfx, int x, int y) {
        gfx.drawString(richText._fontSupplier.get(), Language.getInstance().getVisualOrder(chunk), x, y, richText._textColour.toARGB(), true);
    }

    private static void paintItemStack(RichText richText, ItemStack chunk, GuiGraphics gfx, int x, int y) {
        ModRenderHelper.paintItemStackWithCount(gfx, chunk, x, y, false);
    }

    private static void paintItemStackNoCount(RichText richText, ItemStack chunk, GuiGraphics gfx, int x, int y) {
        ModRenderHelper.paintItemStack(gfx, chunk, x, y, "", false);
    }

    private static void paintSprite(RichText richText, ISprite chunk, GuiGraphics gfx, int x, int y) {
        ModRenderHelper.paintSprite(gfx, chunk, new Point(x, y), 0, 16, 16);
    }

    public static class Builder {
        private static final ITextChunk EMPTY = new TextChunk<String>("", 5, 5, (richText, chunk, matrix, x, y) -> {});
        private static final List<TextLine> EMPTY_LINE = ObjectLists.unmodifiable((ObjectList)ObjectLists.singleton((Object)TextLine.from(EMPTY)));
        private final int _maxWidth;
        protected List<Component> _lines;
        protected List<Object> _objects;
        protected Supplier<@NotNull Font> _fontSupplier;
        protected Colour _textColour;
        protected int _interline;

        public RichText build() {
            RichText rich = new RichText(this._fontSupplier, this.buildLines());
            rich._textColour = this._textColour;
            rich._interline = this._interline;
            return rich;
        }

        public Builder textLines(List<Component> lines) {
            Preconditions.checkArgument((!lines.isEmpty() ? 1 : 0) != 0);
            this._lines = lines;
            return this;
        }

        public Builder textLines(Component line) {
            return this.textLines((List<Component>)ImmutableList.of((Object)line));
        }

        public Builder textLines(Component ... lines) {
            return this.textLines((List<Component>)ImmutableList.copyOf((Object[])lines));
        }

        public Builder objects(List<Object> objects) {
            this._objects = objects;
            return this;
        }

        public Builder font(Supplier<@NotNull Font> font) {
            this._fontSupplier = Objects.requireNonNull(font);
            return this;
        }

        public Builder defaultColour(Colour colour) {
            this._textColour = Objects.requireNonNull(colour);
            return this;
        }

        public Builder interline(int interline) {
            this._interline = interline;
            return this;
        }

        protected Builder(int maxWidth) {
            this._maxWidth = maxWidth;
            this._lines = Collections.emptyList();
            this._objects = Collections.emptyList();
            this._fontSupplier = ModRenderHelper.DEFAULT_FONT_RENDERER;
            this._textColour = Colour.BLACK;
            this._interline = 0;
        }

        protected List<TextLine> buildLines() {
            return (List)this._lines.stream().map(this._objects.isEmpty() ? this::splitPlainText : this::splitFormattedText).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        }

        protected List<TextLine> splitPlainText(Component component) {
            List<FormattedText> textProperties = this.split(component);
            if (textProperties.isEmpty()) {
                return EMPTY_LINE;
            }
            return (List)textProperties.stream().map(this::line).collect(ImmutableList.toImmutableList());
        }

        protected List<TextLine> splitFormattedText(Component component) {
            List<FormattedText> textProperties = this.split(component);
            if (textProperties.isEmpty()) {
                return EMPTY_LINE;
            }
            int objectsCount = this._objects.size();
            LinkedList textLines = Lists.newLinkedList();
            StringBuilder sb = new StringBuilder();
            for (FormattedText tp : textProperties) {
                String text = tp.getString();
                if (!text.contains("@")) {
                    textLines.add(this.line(tp));
                    continue;
                }
                ArrayList chunks = Lists.newArrayList();
                for (int index = 0; index < text.length(); ++index) {
                    String currentChar = text.substring(index, index + 1);
                    if ("@".equals(currentChar)) {
                        int objectIndex;
                        if (16 == (objectIndex = text.charAt(++index) - 48)) {
                            sb.append('@');
                            continue;
                        }
                        if (objectIndex < 0 || objectIndex > 9 || objectIndex >= objectsCount) {
                            throw new IllegalArgumentException(text);
                        }
                        if (!sb.isEmpty()) {
                            chunks.add(this.chunk(sb, component.getStyle()));
                            sb = new StringBuilder();
                        }
                        chunks.add(this.genericChunk(this._objects.get(objectIndex)));
                        continue;
                    }
                    sb.append(currentChar);
                }
                if (!sb.isEmpty()) {
                    chunks.add(this.chunk(sb, component.getStyle()));
                }
                textLines.add(TextLine.from(chunks));
            }
            return textLines;
        }

        protected List<FormattedText> split(Component component) {
            return ModRenderHelper.splitLines(this._fontSupplier.get(), (FormattedText)component, this._maxWidth, component.getStyle());
        }

        protected TextLine line(FormattedText tp) {
            return TextLine.from(this.chunk(tp));
        }

        protected ITextChunk chunk(FormattedText text) {
            int n = this._fontSupplier.get().width(text);
            Objects.requireNonNull(this._fontSupplier.get());
            return new TextChunk<FormattedText>(text, n, 9, RichText::paintString);
        }

        protected ITextChunk chunk(StringBuilder builder, Style style) {
            return this.chunk((FormattedText)Component.literal((String)builder.toString()).setStyle(style));
        }

        protected ITextChunk chunk(String text) {
            int n = this._fontSupplier.get().width(text);
            Objects.requireNonNull(this._fontSupplier.get());
            return new TextChunk<String>(text, n, 9, RichText::paintString);
        }

        private ITextChunk chunk(StringSupplier text) {
            return new DynamicTextChunk(text, this._fontSupplier);
        }

        private ITextChunk chunk(ComponentSupplier text) {
            return new TranslationTextChunk(text, this._fontSupplier);
        }

        private ITextChunk chunk(ItemStack stack) {
            return new TextChunk<ItemStack>(stack, 16, 16, RichText::paintItemStack);
        }

        private ITextChunk chunk(ItemLike item) {
            return new TextChunk<ItemStack>(new ItemStack(item), 16, 16, RichText::paintItemStackNoCount);
        }

        private ITextChunk chunk(ISprite sprite) {
            return new TextChunk<ISprite>(sprite, 16, 16, RichText::paintSprite);
        }

        private ITextChunk genericChunk(Object thing) {
            if (thing instanceof String) {
                return this.chunk((String)thing);
            }
            if (thing instanceof StringSupplier) {
                return this.chunk((StringSupplier)thing);
            }
            if (thing instanceof ComponentSupplier) {
                return this.chunk((ComponentSupplier)thing);
            }
            if (thing instanceof Component) {
                return this.chunk((FormattedText)((Component)thing));
            }
            if (thing instanceof ItemStack) {
                return this.chunk((ItemStack)thing);
            }
            if (thing instanceof Item) {
                return this.chunk((ItemLike)((Item)thing));
            }
            if (thing instanceof Block) {
                return this.chunk((ItemLike)((Block)thing));
            }
            if (thing instanceof ISprite) {
                return this.chunk((ISprite)thing);
            }
            return EMPTY;
        }
    }

    private static class TextLine
    implements ITextChunk {
        final ObjectList<ITextChunk> _chunks;
        final int _maxWidth;
        final int _maxHeight;
        final boolean _dynamic;

        public static TextLine from(ITextChunk chunk) {
            return new TextLine(chunk);
        }

        public static TextLine from(List<ITextChunk> chunks) {
            return 1 == chunks.size() ? new TextLine(chunks.get(0)) : new TextLine(chunks);
        }

        private TextLine(ITextChunk chunk) {
            Preconditions.checkNotNull((Object)chunk);
            this._chunks = ObjectLists.unmodifiable((ObjectList)ObjectLists.singleton((Object)chunk));
            this._dynamic = false;
            this._maxWidth = chunk.getWidth();
            this._maxHeight = chunk.getHeight();
        }

        private TextLine(List<ITextChunk> chunks) {
            Preconditions.checkArgument((!chunks.isEmpty() ? 1 : 0) != 0);
            this._chunks = ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(chunks));
            this._dynamic = this._chunks.stream().anyMatch(c -> c instanceof DynamicTextChunk);
            this._maxWidth = this._dynamic ? -1 : this.computeMaxWidth();
            this._maxHeight = this._chunks.stream().mapToInt(ITextChunk::getHeight).max().orElse(0);
        }

        public boolean isDynamic() {
            return this._dynamic;
        }

        @Override
        public int getWidth() {
            return this._dynamic ? this.computeMaxWidth() : this._maxWidth;
        }

        @Override
        public int getHeight() {
            return this._maxHeight;
        }

        @Override
        public void paint(RichText richText, GuiGraphics gfx, int x, int y) {
            for (ITextChunk chunk : this._chunks) {
                chunk.paint(richText, gfx, x, y + (this._maxHeight - chunk.getHeight()) / 2);
                x += chunk.getWidth();
            }
        }

        private int computeMaxWidth() {
            return this._chunks.stream().mapToInt(ITextChunk::getWidth).sum();
        }
    }

    private static class TranslationTextChunk
    extends TextChunk<ComponentSupplier> {
        private final Supplier<@NotNull Font> _fontSupplier;

        public TranslationTextChunk(ComponentSupplier thing, Supplier<@NotNull Font> fontSupplier) {
            Objects.requireNonNull(fontSupplier.get());
            super(thing, 0, 9, TranslationTextChunk::paintString);
            this._fontSupplier = fontSupplier;
        }

        @Override
        public int getWidth() {
            return this._fontSupplier.get().width((FormattedText)((ComponentSupplier)this.get()).get());
        }

        private static void paintString(RichText richText, ComponentSupplier chunk, GuiGraphics gfx, int x, int y) {
            RichText.paintString(richText, (FormattedText)chunk.get(), gfx, x, y);
        }
    }

    private static class DynamicTextChunk
    extends TextChunk<StringSupplier> {
        private final Supplier<@NotNull Font> _fontSupplier;

        public DynamicTextChunk(StringSupplier thing, Supplier<@NotNull Font> fontSupplier) {
            Objects.requireNonNull(fontSupplier.get());
            super(thing, 0, 9, DynamicTextChunk::paintString);
            this._fontSupplier = fontSupplier;
        }

        @Override
        public int getWidth() {
            return this._fontSupplier.get().width((String)((StringSupplier)this.get()).get());
        }

        private static void paintString(RichText richText, StringSupplier chunk, GuiGraphics gfx, int x, int y) {
            RichText.paintString(richText, (String)chunk.get(), gfx, x, y);
        }
    }

    private static class TextChunk<T>
    implements ITextChunk,
    Supplier<T> {
        private final T _thing;
        private final int _width;
        private final int _height;
        private final IChunkPainter<T> _painter;

        public TextChunk(T thing, int width, int height, IChunkPainter<T> painter) {
            this._thing = Objects.requireNonNull(thing);
            this._width = width;
            this._height = height;
            this._painter = Objects.requireNonNull(painter);
        }

        @Override
        public int getWidth() {
            return this._width;
        }

        @Override
        public int getHeight() {
            return this._height;
        }

        @Override
        public void paint(RichText richText, GuiGraphics gfx, int x, int y) {
            this._painter.paint(richText, this._thing, gfx, x, y);
        }

        @Override
        public T get() {
            return this._thing;
        }

        @FunctionalInterface
        public static interface IChunkPainter<T> {
            public void paint(RichText var1, T var2, GuiGraphics var3, int var4, int var5);
        }
    }

    private static interface ITextChunk {
        public int getWidth();

        public int getHeight();

        public void paint(RichText var1, GuiGraphics var2, int var3, int var4);
    }
}

