/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.network;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.ZeroCore;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.network.AbstractBlockEntityPlayPacket;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class TileCommandMessage
extends AbstractBlockEntityPlayPacket<TileCommandMessage> {
    public static final CustomPacketPayload.Type<TileCommandMessage> TYPE = TileCommandMessage.createType(ZeroCore.ROOT_LOCATION, "tile_command");
    public static final StreamCodec<ByteBuf, TileCommandMessage> STREAM_CODEC = TileCommandMessage.createStreamCodec(ByteBufCodecs.STRING_UTF8, packet -> packet._name, ByteBufCodecs.COMPOUND_TAG, packet -> packet._parameters, TileCommandMessage::new);
    private final String _name;
    private final CompoundTag _parameters;

    public TileCommandMessage(GlobalPos position, String commandName, CompoundTag commandParameters) {
        super(TYPE, position);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commandName) ? 1 : 0) != 0, (Object)"Command name must not be null or empty");
        Preconditions.checkNotNull((Object)commandParameters, (Object)"Command parameters must not be null");
        this._name = commandName;
        this._parameters = commandParameters;
    }

    public TileCommandMessage(AbstractModBlockEntity blockEntity, String commandName, CompoundTag commandParameters) {
        super(TYPE, blockEntity);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commandName) ? 1 : 0) != 0, (Object)"Command name must not be null or empty");
        Preconditions.checkNotNull((Object)commandParameters, (Object)"Command parameters must not be null");
        this._name = commandName;
        this._parameters = commandParameters;
    }

    @Override
    protected void processBlockEntity(PacketFlow flow, BlockEntity blockEntity) {
        if (blockEntity instanceof AbstractModBlockEntity) {
            AbstractModBlockEntity be = (AbstractModBlockEntity)blockEntity;
            be.handleCommand(flow, this._name, this._parameters);
        } else {
            Log.LOGGER.error(Log.NETWORK, "No command-aware Tile Entity found while processing a command message: skipping");
        }
    }
}

