/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor;

import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorBehaviorPanel;
import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorGroupPanelBuilder;
import it.zerono.mods.zerocore.base.redstone.sensor.AbstractSensorSetting;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorSettingFactory;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.control.ChoiceText;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.PanelGroup;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import java.util.List;
import net.minecraft.network.chat.Component;

class SensorBehaviorGroupPanel<Reader extends IMachineReader, Writer, SensorType extends Enum<SensorType>, SensorSetting extends AbstractSensorSetting<Reader, Writer, SensorType, SensorSetting>>
extends Panel {
    private final SensorType _sensor;
    private final ChoiceText<SensorBehavior> _behaviorChoice;
    private final PanelGroup<SensorBehavior> _group;

    public SensorBehaviorGroupPanel(SensorGroupPanelBuilder.BehaviorGroupBuilder builder) {
        super(builder.getGui(), ((Enum)builder.getSensor()).name() + "Behaviors");
        this.setDesiredDimension(builder.getWidth(), builder.getHeight());
        this.setLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setZeroMargins()).setControlsSpacing(3)).setHorizontalAlignment(HorizontalAlignment.Left)).setVerticalAlignment(VerticalAlignment.Top));
        List<SensorBehavior> behaviors = builder.getBehaviors();
        this._sensor = builder.getSensor();
        this._behaviorChoice = new ChoiceText<SensorBehavior>(builder.getGui(), ((Enum)this._sensor).name() + "Behavior", behaviors);
        this._group = new PanelGroup<SensorBehavior>(builder.getGui(), "group", behaviors);
        behaviors.forEach(behavior -> this._behaviorChoice.addText((SensorBehavior)((Object)behavior), (Component)TextHelper.translatable("gui.zerocore.base.redstone.sensorbehavior." + CodeHelper.neutralLowercase(behavior.name()) + ".text")));
        if (behaviors.size() == 1) {
            this._behaviorChoice.setEnabled(false);
        }
        int height = builder.getHeight();
        this._behaviorChoice.Changed.subscribe((choice, behavior) -> this._group.setActivePanel((SensorBehavior)((Object)behavior)));
        this._behaviorChoice.setSelectedIndex(behaviors.get(0));
        this._behaviorChoice.setDesiredDimension(builder.getWidth(), 16);
        this.addControl((IControl)this._behaviorChoice);
        this._group.setDesiredDimension(builder.getWidth(), height -= 16);
        this.addControl((IControl)this._group);
        for (SensorBehavior behavior2 : behaviors) {
            this._group.setPanel(behavior2, new SensorBehaviorPanel(builder.getBehaviorBuilder(behavior2)));
        }
    }

    public SensorSetting getSettings(ISensorSettingFactory<Reader, Writer, SensorType, SensorSetting> sensorSettingFactory, SensorSetting defaultValue) {
        return (SensorSetting)this._group.getActivePanel().filter(panel -> panel instanceof SensorBehaviorPanel).map(panel -> (SensorBehaviorPanel)panel).map(panel -> panel.getSettings(sensorSettingFactory, this._sensor)).orElse((AbstractSensorSetting)defaultValue);
    }

    public void resetControls() {
        this._behaviorChoice.setSelectedIndex((SensorBehavior)((Object)this._behaviorChoice.getValidIndices().get(0)));
        this._group.clearActivePanel();
        this._group.stream().filter(panel -> panel instanceof SensorBehaviorPanel).map(panel -> (SensorBehaviorPanel)panel).forEach(SensorBehaviorPanel::resetControls);
    }

    public void setSettings(SensorSetting setting) {
        this._behaviorChoice.setSelectedIndex(((AbstractSensorSetting)setting).Behavior);
        this._group.getActivePanel().filter(panel -> panel instanceof SensorBehaviorPanel).map(panel -> (SensorBehaviorPanel)panel).ifPresent(panel -> panel.setSettings(setting));
    }
}

