/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen;

import it.zerono.mods.zerocore.base.CommonConstants;
import it.zerono.mods.zerocore.base.client.screen.BaseIcons;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import java.util.function.Supplier;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public final class ClientBaseHelper {
    public static final int LABEL_HEIGHT = 10;
    public static final int PUSH_BUTTON_HEIGHT = 16;
    public static final int SQUARE_BUTTON_DIMENSION = 18;
    public static final int INVENTORY_SLOTS_ROW_WIDTH = 162;

    public static MutableComponent formatAsTitle(MutableComponent text) {
        return text.setStyle(CommonConstants.STYLE_TOOLTIP_TITLE);
    }

    public static MutableComponent formatAsValue(MutableComponent text) {
        return text.setStyle(CommonConstants.STYLE_TOOLTIP_VALUE);
    }

    public static MutableComponent formatAsInfo(MutableComponent text) {
        return text.setStyle(CommonConstants.STYLE_TOOLTIP_INFO);
    }

    public static void setButtonSpritesAndOverlayForState(AbstractButtonControl button, ButtonState standardState, Supplier<@NotNull ISprite> standardSprite) {
        ClientBaseHelper.setButtonSpritesAndOverlayForState(button, standardState, standardSprite.get());
    }

    public static void setButtonSpritesAndOverlayForState(AbstractButtonControl button, ButtonState standardState, ISprite standardSprite) {
        button.setIconForState(standardSprite, standardState);
        ISprite withOverlay = standardSprite.copyWith(BaseIcons.Button16x16HightlightOverlay.get());
        button.setIconForState(withOverlay, standardState.getHighlighted());
        withOverlay = standardSprite.copyWith(BaseIcons.Button16x16DisabledOverlay.get());
        button.setIconForState(withOverlay, standardState.getDisabled());
    }

    private ClientBaseHelper() {
    }
}

