/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yogpc.qp.machine.marker.FlexibleMarkerEntity;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.RenderMarker;
import com.yogpc.qp.render.Sprites;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RenderFlexibleMarker
implements BlockEntityRenderer<FlexibleMarkerEntity> {
    public RenderFlexibleMarker(BlockEntityRendererProvider.Context context) {
    }

    public void render(FlexibleMarkerEntity marker, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Minecraft.getInstance().getProfiler().push("quarryplus");
        Minecraft.getInstance().getProfiler().push("flexible_marker");
        poseStack.pushPose();
        BlockPos markerPos = marker.getBlockPos();
        poseStack.translate((float)(-markerPos.getX()), (float)(-markerPos.getY()), (float)(-markerPos.getZ()));
        Direction direction = marker.getDirection();
        double a = 0.5;
        double c = 0.375;
        if (direction != null) {
            AABB bb = direction.getAxis() == Direction.Axis.X ? new AABB((double)markerPos.getX() - 0.375 + 0.5, (double)markerPos.getY() + 0.5, (double)markerPos.getZ() + 0.5, (double)markerPos.getX() + 0.375 + 0.5, (double)markerPos.getY() + 0.5, (double)markerPos.getZ() + 0.5) : new AABB((double)markerPos.getX() + 0.5, (double)markerPos.getY() + 0.5, (double)markerPos.getZ() - 0.375 + 0.5, (double)markerPos.getX() + 0.5, (double)markerPos.getY() + 0.5, (double)markerPos.getZ() + 0.375 + 0.5);
            Box directionBox = Box.apply(bb.move(Vec3.atLowerCornerOf((Vec3i)direction.getNormal()).scale(0.5)), 0.125, 0.125, 0.125, true, true);
            directionBox.render(bufferSource.getBuffer(RenderType.cutout()), poseStack, Sprites.INSTANCE.getWhite(), ColorBox.blueColor);
        }
        marker.getLink().ifPresent(link -> RenderMarker.renderLink(poseStack, bufferSource, link, ColorBox.redColor));
        poseStack.popPose();
        Minecraft.getInstance().getProfiler().pop();
        Minecraft.getInstance().getProfiler().pop();
    }
}

