/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.neoforge.integration;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.PowerEntity;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public final class EnergyIntegration {
    @SubscribeEvent
    public static void attachCapabilities(RegisterCapabilitiesEvent event) {
        for (BlockEntityType<?> blockEntityType : PlatformAccess.getAccess().registerObjects().getBlockEntityTypes()) {
            event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, blockEntityType, EnergyIntegration::provider);
        }
    }

    @Nullable
    private static IEnergyStorage provider(Object entity, Direction direction) {
        if (entity instanceof PowerEntity) {
            PowerEntity powerEntity = (PowerEntity)((Object)entity);
            return new PowerEntityStorage(powerEntity, direction);
        }
        return null;
    }

    record PowerEntityStorage(PowerEntity entity) implements IEnergyStorage
    {
        PowerEntityStorage(PowerEntity entity, Direction ignored) {
            this(entity);
        }

        static int clamp(long value) {
            return Math.clamp(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            long received = this.entity.addEnergy((long)maxReceive * 1000000000L, simulate);
            return PowerEntityStorage.clamp(received / 1000000000L);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return PowerEntityStorage.clamp(this.entity.getEnergy() / 1000000000L);
        }

        public int getMaxEnergyStored() {
            return PowerEntityStorage.clamp(this.entity.getMaxEnergy() / 1000000000L);
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

