/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.placer;

import com.mojang.serialization.DynamicOps;
import com.yogpc.qp.machine.placer.AbstractPlacerTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public final class RemotePlacerEntity
extends AbstractPlacerTile {
    public static final String KEY_TARGET = "targetPos";
    @NotNull
    BlockPos targetPos;

    public RemotePlacerEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
        this.targetPos = pos.above();
    }

    @Override
    @NotNull
    protected BlockPos getTargetPos() {
        return this.targetPos;
    }

    @Override
    protected Direction getMachineFacing() {
        return Direction.UP;
    }

    @Override
    public void fromClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.fromClientTag(tag, registries);
        this.targetPos = (BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(KEY_TARGET)).getOrThrow();
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put(KEY_TARGET, (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.targetPos).getOrThrow());
        return super.toClientTag(tag, registries);
    }
}

