/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.mojang.serialization.DynamicOps;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.Area;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.marker.QuarryMarker;
import com.yogpc.qp.packet.ClientSync;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class FlexibleMarkerEntity
extends QpEntity
implements QuarryMarker,
ClientSync {
    @NotNull
    BlockPos min;
    @NotNull
    BlockPos max;
    Direction direction = Direction.NORTH;

    public FlexibleMarkerEntity(@NotNull BlockPos pos, BlockState blockState) {
        super(pos, blockState);
        this.min = pos;
        this.max = pos;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.toClientTag(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fromClientTag(tag, registries);
    }

    @Override
    public void fromClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.min = (BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("min")).getOrThrow();
        this.max = (BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("max")).getOrThrow();
        this.direction = (Direction)Direction.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("direction")).getOrThrow();
    }

    @Override
    public CompoundTag toClientTag(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("min", (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.min).getOrThrow());
        tag.put("max", (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.max).getOrThrow());
        tag.put("direction", (Tag)Direction.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.direction).getOrThrow());
        return tag;
    }

    @Override
    public Stream<MutableComponent> checkerLogs() {
        return Stream.concat(super.checkerLogs(), Stream.of(FlexibleMarkerEntity.detail(ChatFormatting.GREEN, "min", String.valueOf(this.min)), FlexibleMarkerEntity.detail(ChatFormatting.GREEN, "max", String.valueOf(this.max))));
    }

    public void init(Direction facing) {
        this.direction = facing;
        this.min = this.getBlockPos();
        this.max = this.getBlockPos();
        this.move(Movable.LEFT, 5);
        this.move(Movable.RIGHT, 5);
        this.move(Movable.FORWARD, 10);
        this.syncToClient();
    }

    void move(Movable movable, int amount) {
        assert (this.level != null);
        Direction facing = movable.getActualFacing(this.direction);
        BlockPos offset = this.getBlockPos();
        if (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            this.max = this.max.relative(facing, amount);
            int d = FlexibleMarkerEntity.getDistance(this.max, offset, facing.getAxis());
            if (d > this.getMaxRange()) {
                this.max = FlexibleMarkerEntity.getLimited(this.max, offset, facing, this.getMaxRange());
            } else if (d < 0) {
                this.max = FlexibleMarkerEntity.getLimited(this.max, offset, facing, 0);
            }
            if (facing == Direction.UP && this.max.getY() >= this.level.getMaxBuildHeight()) {
                this.max = new BlockPos(this.max.getX(), this.level.getMaxBuildHeight() - 1, this.max.getZ());
            }
        } else {
            this.min = this.min.relative(facing, amount);
            int d = FlexibleMarkerEntity.getDistance(offset, this.min, facing.getAxis());
            if (d > this.getMaxRange()) {
                this.min = FlexibleMarkerEntity.getLimited(this.min, offset, facing, this.getMaxRange());
            } else if (d < 0) {
                this.min = FlexibleMarkerEntity.getLimited(this.min, offset, facing, 0);
            }
            if (facing == Direction.DOWN && this.min.getY() < this.level.getMinBuildHeight()) {
                this.min = new BlockPos(this.min.getX(), this.level.getMinBuildHeight(), this.min.getZ());
            }
        }
    }

    int getMaxRange() {
        return PlatformAccess.config().flexibleMarkerRange();
    }

    public static int getDistance(BlockPos to, BlockPos from, Direction.Axis axis) {
        return to.get(axis) - from.get(axis);
    }

    public static BlockPos getLimited(BlockPos to, BlockPos from, Direction facing, int limit) {
        return switch (facing.getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> new BlockPos(from.getX(), to.getY(), to.getZ()).relative(facing, limit);
            case Direction.Axis.Y -> new BlockPos(to.getX(), from.getY(), to.getZ()).relative(facing, limit);
            case Direction.Axis.Z -> new BlockPos(to.getX(), to.getY(), from.getZ()).relative(facing, limit);
        };
    }

    @Override
    public Optional<QuarryMarker.Link> getLink() {
        return Optional.of(this.createLink());
    }

    FlexibleMarkerLink createLink() {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock());
        return new FlexibleMarkerLink(this.getBlockPos(), this.min, this.max, this.direction, stack);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public AABB getRenderAabb() {
        FlexibleMarkerLink link = this.createLink();
        Area area = link.area();
        return new AABB((double)area.minX(), (double)area.minY(), (double)area.minZ(), (double)area.maxX(), (double)area.maxY(), (double)area.maxZ());
    }

    public static enum Movable {
        UP(facing -> Direction.UP),
        LEFT(Direction::getCounterClockWise),
        FORWARD(UnaryOperator.identity()),
        RIGHT(Direction::getClockWise),
        DOWN(facing -> Direction.DOWN);

        private final UnaryOperator<Direction> operator;
        public final String transName;

        private Movable(UnaryOperator<Direction> operator) {
            this.operator = operator;
            this.transName = "gui." + this.name().toLowerCase(Locale.US);
        }

        public Direction getActualFacing(Direction facing) {
            return (Direction)this.operator.apply(facing);
        }

        public static Movable valueOf(int i) {
            return Movable.values()[i];
        }

        public int distanceFromOrigin(BlockPos origin, BlockPos areaMin, BlockPos areaMax, Direction facing) {
            Direction actualFacing = this.getActualFacing(facing);
            BlockPos relative = actualFacing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? areaMax : areaMin;
            return Math.abs(FlexibleMarkerEntity.getDistance(origin, relative, actualFacing.getAxis()));
        }
    }

    record FlexibleMarkerLink(BlockPos markerPos, BlockPos min, BlockPos max, Direction direction, ItemStack stack) implements QuarryMarker.Link
    {
        @Override
        public Area area() {
            return new Area((Vec3i)this.min, (Vec3i)this.max, this.direction);
        }

        @Override
        public void remove(Level level) {
            level.removeBlock(this.markerPos, false);
        }

        @Override
        public List<ItemStack> drops() {
            return List.of(this.stack);
        }
    }
}

