/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.marker;

import com.yogpc.qp.machine.marker.ChunkMarkerEntity;
import com.yogpc.qp.packet.OnReceiveWithLevel;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class ChunkMarkerMessage
implements CustomPacketPayload,
OnReceiveWithLevel {
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"chunk_marker_message");
    public static final CustomPacketPayload.Type<ChunkMarkerMessage> TYPE = new CustomPacketPayload.Type(NAME);
    public static final StreamCodec<FriendlyByteBuf, ChunkMarkerMessage> STREAM_CODEC = CustomPacketPayload.codec(ChunkMarkerMessage::write, ChunkMarkerMessage::new);
    private final BlockPos pos;
    private final ResourceKey<Level> dim;
    private final int size;
    private final int minY;
    private final int maxY;

    public ChunkMarkerMessage(ChunkMarkerEntity marker) {
        this.pos = marker.getBlockPos();
        this.dim = Objects.requireNonNull(marker.getLevel()).dimension();
        this.size = marker.size;
        this.minY = marker.minY;
        this.maxY = marker.maxY;
    }

    public ChunkMarkerMessage(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buffer.readResourceLocation());
        this.size = buffer.readVarInt();
        this.minY = buffer.readVarInt();
        this.maxY = buffer.readVarInt();
    }

    void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos).writeResourceKey(this.dim);
        buffer.writeVarInt(this.size);
        buffer.writeVarInt(this.minY);
        buffer.writeVarInt(this.maxY);
    }

    @Override
    public void onReceive(Level level, Player player) {
        if (!level.dimension().equals(this.dim)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof ChunkMarkerEntity) {
            ChunkMarkerEntity marker = (ChunkMarkerEntity)blockEntity;
            if (marker.enabled) {
                marker.size = this.size;
                marker.minY = this.minY;
                marker.maxY = this.maxY;
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

