/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.advquarry;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.advquarry.AdvActionSyncMessage;
import com.yogpc.qp.machine.advquarry.AdvQuarryEntity;
import com.yogpc.qp.machine.advquarry.WorkConfig;
import com.yogpc.qp.packet.OnReceiveWithLevel;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class AdvQuarryInitialAskMessage
implements CustomPacketPayload,
OnReceiveWithLevel {
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"adv_quarry_initial_ask_message");
    public static final CustomPacketPayload.Type<AdvQuarryInitialAskMessage> TYPE = new CustomPacketPayload.Type(NAME);
    public static final StreamCodec<FriendlyByteBuf, AdvQuarryInitialAskMessage> STREAM_CODEC = CustomPacketPayload.codec(AdvQuarryInitialAskMessage::write, AdvQuarryInitialAskMessage::new);
    private final BlockPos pos;
    private final ResourceKey<Level> dim;

    public AdvQuarryInitialAskMessage(BlockPos pos, ResourceKey<Level> dim) {
        this.dim = dim;
        this.pos = pos;
    }

    AdvQuarryInitialAskMessage(AdvQuarryEntity entity) {
        this(entity.getBlockPos(), (ResourceKey<Level>)Objects.requireNonNull(entity.getLevel()).dimension());
    }

    AdvQuarryInitialAskMessage(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.dim = buf.readResourceKey(Registries.DIMENSION);
    }

    void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos).writeResourceKey(this.dim);
    }

    @Override
    public void onReceive(Level level, Player player) {
        if (!level.dimension().equals(this.dim)) {
            return;
        }
        BlockEntity entity = level.getBlockEntity(this.pos);
        if (entity instanceof AdvQuarryEntity) {
            AdvQuarryEntity quarry = (AdvQuarryEntity)entity;
            quarry.workConfig = PlatformAccess.config().noEnergy() ? WorkConfig.DEFAULT.noAutoStartConfig() : WorkConfig.DEFAULT;
            PlatformAccess.getAccess().packetHandler().sendToServer(new AdvActionSyncMessage(quarry, false));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

