/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.item.sandwich;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.loading.FMLEnvironment;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.item.sandwich.SandwichContents;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModTags;

public class SandwichNameHelper {
    public static Component getSandwichDisplayName(ItemStack stack) {
        boolean isOpenFacedSandwich;
        String sandwichType;
        SandwichContents contents = SandwichContents.get(stack);
        if (contents.isEmpty() || BuiltInRegistries.ITEM.getTags().noneMatch(p -> ((TagKey)p.getFirst()).equals(ModTags.SANDWICH_BREAD))) {
            return SandwichNameHelper.translate("base", "sandwich");
        }
        int breadCount = SandwichNameHelper.countItems(contents, ModTags.SANDWICH_BREAD);
        int bunCount = SandwichNameHelper.countItems(contents, ModTags.BURGER_BUNS);
        String string = sandwichType = bunCount > breadCount - bunCount ? "burger" : "sandwich";
        if (contents.size() == breadCount) {
            return SandwichNameHelper.getBreadSandwichName(contents, sandwichType);
        }
        List<ItemStack> uniqueIngredients = SandwichNameHelper.getUniqueIngredientsExcludingBread(contents);
        List<ItemStack> potions = uniqueIngredients.stream().filter(item -> item.is(Items.POTION)).toList();
        if (potions.size() == 1) {
            if (FMLEnvironment.dist.isDedicatedServer()) {
                return SandwichNameHelper.translate("base", "sandwich");
            }
            return SandwichNameHelper.getPotionSandwichName(potions.getFirst(), sandwichType);
        }
        boolean bl = isOpenFacedSandwich = breadCount == 1 && contents.size() > 1;
        if (!uniqueIngredients.isEmpty() && uniqueIngredients.size() <= 3) {
            Component ingredientList = SandwichNameHelper.listIngredients(uniqueIngredients);
            if (contents.isDoubleDecker()) {
                return SandwichNameHelper.translateWithArg("double_decker", "with_ingredients", sandwichType, ingredientList);
            }
            if (isOpenFacedSandwich) {
                return SandwichNameHelper.translateWithArg("open_faced", "with_ingredients", sandwichType, ingredientList);
            }
            return SandwichNameHelper.translateWithArg("base", "with_ingredients", sandwichType, ingredientList);
        }
        if (contents.isDoubleDecker()) {
            return SandwichNameHelper.translate("double_decker", sandwichType);
        }
        if (isOpenFacedSandwich) {
            return SandwichNameHelper.translate("open_faced", sandwichType);
        }
        return SandwichNameHelper.translate("base", sandwichType);
    }

    private static List<ItemStack> getUniqueIngredientsExcludingBread(SandwichContents sandwich) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack ingredient : sandwich) {
            if (ingredient.is(ModTags.SANDWICH_BREAD) || !result.stream().noneMatch(stack -> ItemStack.matches((ItemStack)ingredient, (ItemStack)stack))) continue;
            result.add(ingredient);
        }
        return result;
    }

    private static int countItems(SandwichContents sandwich, TagKey<Item> tagKey) {
        int result = 0;
        for (ItemStack ingredient : sandwich) {
            if (!ingredient.is(tagKey)) continue;
            ++result;
        }
        return result;
    }

    private static Component getBreadSandwichName(SandwichContents contents, String sandwichType) {
        if (contents.size() == 3 && ((ItemStack)contents.getFirst()).getItem() != ModItems.TOASTED_BREAD_SLICE.get() && contents.get(1).getItem() == ModItems.TOASTED_BREAD_SLICE.get() && contents.get(2).getItem() != ModItems.TOASTED_BREAD_SLICE.get()) {
            return SandwichNameHelper.translateWithArg("base", "with_ingredients", sandwichType, Ingredients.getDisplayName(contents.get(1)));
        }
        return SandwichNameHelper.translate("only_bread", sandwichType);
    }

    private static Component listIngredients(List<ItemStack> ingredients) {
        List<Component> ingredientNames = ingredients.stream().map(Ingredients::getDisplayName).toList();
        return SomeAssemblyRequired.translate("tooltip.ingredient_list.%s".formatted(ingredientNames.size()), ingredientNames.toArray());
    }

    private static Component translateWithArg(Object ... keys) {
        return Component.translatable((String)SandwichNameHelper.translationKey(Arrays.copyOfRange(keys, 0, keys.length - 1)), (Object[])new Object[]{keys[keys.length - 1]});
    }

    private static Component translate(Object ... keys) {
        return Component.translatable((String)SandwichNameHelper.translationKey(keys));
    }

    private static String translationKey(Object ... keys) {
        StringBuilder builder = new StringBuilder("item.%s.sandwich".formatted("someassemblyrequired"));
        for (Object key : keys) {
            builder.append('.');
            builder.append(key);
        }
        return builder.toString();
    }

    private static Component getPotionSandwichName(ItemStack potionItem, String sandwichType) {
        Optional potion = ((PotionContents)potionItem.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).potion();
        if (potion.isPresent()) {
            ResourceLocation id = Objects.requireNonNull(BuiltInRegistries.POTION.getKey((Object)((Potion)((Holder)potion.get()).value())));
            String key = SandwichNameHelper.translationKey("potion", "with_id", id.getNamespace(), id.getPath(), sandwichType);
            if (I18n.exists((String)key)) {
                return Component.translatable((String)key);
            }
        }
        String potionKey = potion.map(potionHolder -> PotionContents.createItemStack((Item)Items.POTION, (Holder)potionHolder)).orElse(new ItemStack((ItemLike)Items.POTION)).getDescriptionId();
        int i = 1;
        do {
            Pattern pattern = Pattern.compile(I18n.get((String)SandwichNameHelper.translationKey("potion", "pattern", i), (Object[])new Object[0]));
            String replacement = I18n.get((String)SandwichNameHelper.translationKey("potion", "pattern", i, sandwichType), (Object[])new Object[0]);
            Matcher matcher = pattern.matcher(I18n.get((String)potionKey, (Object[])new Object[0]));
            if (!matcher.matches()) continue;
            return Component.literal((String)matcher.replaceAll(replacement));
        } while (I18n.exists((String)SandwichNameHelper.translationKey("potion", "pattern", ++i)));
        return SandwichNameHelper.translateWithArg("base", "with_ingredients", sandwichType, SandwichNameHelper.listIngredients(List.of(potionItem)));
    }
}

