/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.item.sandwich;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.item.sandwich.SandwichContents;
import someassemblyrequired.registry.ModTags;

public class SandwichItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ItemStack BARRIER = new ItemStack((ItemLike)Items.BARRIER);
    private static final Random random = new Random();

    public SandwichItemRenderer() {
        super(null, null);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int overlay) {
        SandwichContents sandwich = SandwichContents.get(stack);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.53125, 0.5);
        int height = sandwich.getTotalHeight();
        if (itemDisplayContext == ItemDisplayContext.GUI && height > 16) {
            float scale = 24.0f / ((float)height + 8.0f);
            poseStack.scale(scale, scale, scale);
        }
        if (itemDisplayContext.firstPerson() || itemDisplayContext == ItemDisplayContext.GUI) {
            poseStack.translate(0.0, (double)(-height) / 32.0, 0.0);
        }
        if (sandwich.isEmpty()) {
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(BARRIER, ItemDisplayContext.FIXED, packedLight, overlay, poseStack, buffer, null, 0);
        } else {
            SandwichItemRenderer.renderSandwich(sandwich, poseStack, buffer, packedLight, overlay, 0L);
        }
        poseStack.popPose();
    }

    public static void renderSandwich(SandwichContents sandwich, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int overlay, long seed) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        random.setSeed(seed);
        for (int slot = 0; slot < sandwich.size(); ++slot) {
            poseStack.pushPose();
            ItemStack stack = sandwich.get(slot);
            if (!stack.is(ModTags.SANDWICH_BREAD)) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 40.0f - 20.0f));
            }
            ItemStack displayStack = Ingredients.getDisplayItem(stack);
            boolean isGui3d = Minecraft.getInstance().getItemRenderer().getModel(stack, null, null, (int)seed + slot).isGui3d();
            if (!Ingredients.shouldRenderAsItem(stack) || isGui3d) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                poseStack.translate(0.0, 0.46875, 0.0);
                if (isGui3d) {
                    poseStack.translate(0.0, -0.25, 0.0);
                }
            }
            poseStack.scale(1.0f, 1.0f, 0.99f);
            Minecraft.getInstance().getItemRenderer().renderStatic(displayStack, ItemDisplayContext.FIXED, packedLight, overlay, poseStack, buffer, null, (int)seed + slot);
            poseStack.popPose();
            int height = Ingredients.getHeight(stack);
            poseStack.translate(0.0, 0.0, (double)(-height) / 16.0);
        }
        poseStack.popPose();
    }
}

