/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.item.sandwich;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.block.SandwichBlock;
import someassemblyrequired.config.ModConfig;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.integration.ModCompat;
import someassemblyrequired.item.sandwich.SandwichContents;
import someassemblyrequired.item.sandwich.SandwichNameHelper;
import someassemblyrequired.registry.ModAdvancementTriggers;
import someassemblyrequired.registry.ModDataComponents;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModStatistics;
import someassemblyrequired.registry.ModTags;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SandwichItem
extends BlockItem {
    public SandwichItem(Block block, Item.Properties builder) {
        super(block, builder);
    }

    public static ItemStack makeSandwich(Holder<Potion> potion) {
        return SandwichItem.makeSandwich(PotionContents.createItemStack((Item)Items.POTION, potion));
    }

    public static ItemStack makeSandwich(ItemLike ... items) {
        return SandwichItem.makeSandwich((ItemStack[])Arrays.stream(items).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public static ItemStack makeSandwich(ItemStack ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.BREAD_SLICE.get()));
        list.addAll(Arrays.asList(items));
        list.add(new ItemStack((ItemLike)ModItems.BREAD_SLICE.get()));
        return SandwichItem.of(list);
    }

    public static ItemStack makeToastSandwich(ItemLike ... items) {
        return SandwichItem.makeToastSandwich((ItemStack[])Arrays.stream(items).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public static ItemStack makeToastSandwich(ItemStack ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.TOASTED_BREAD_SLICE.get()));
        list.addAll(Arrays.asList(items));
        list.add(new ItemStack((ItemLike)ModItems.TOASTED_BREAD_SLICE.get()));
        return SandwichItem.of(list);
    }

    public static ItemStack makeBurger(ItemLike ... items) {
        return SandwichItem.makeBurger((ItemStack[])Arrays.stream(items).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public static ItemStack makeBurger(ItemStack ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.BURGER_BUN_BOTTOM.get()));
        list.addAll(Arrays.asList(items));
        list.add(new ItemStack((ItemLike)ModItems.BURGER_BUN_TOP.get()));
        return SandwichItem.of(list);
    }

    public static ItemStack of(ItemStack ... items) {
        return SandwichItem.of(Arrays.asList(items));
    }

    public static ItemStack of(List<ItemStack> items) {
        ArrayList<ItemStack> flattenedItems = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            if (item.getCount() != 1) {
                throw new IllegalArgumentException();
            }
            if (item.is((Item)ModItems.SANDWICH.get())) {
                flattenedItems.addAll(SandwichContents.get(item));
                continue;
            }
            flattenedItems.add(item);
        }
        ItemStack result = new ItemStack((ItemLike)ModItems.SANDWICH.get());
        SandwichContents contents = new SandwichContents(flattenedItems);
        result.set((DataComponentType)ModDataComponents.SANDWICH_CONTENTS.get(), (Object)contents);
        return result;
    }

    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        return ((SandwichContents)stack.getOrDefault((DataComponentType)ModDataComponents.SANDWICH_CONTENTS.get(), (Object)SandwichContents.EMPTY)).createFoodProperties(entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        SandwichContents sandwich = SandwichContents.get(stack);
        if (((Boolean)ModConfig.client.listItemsInTooltip.get()).booleanValue()) {
            sandwich.stream().collect(Collectors.groupingBy(item -> Ingredients.getFullName(item).plainCopy(), LinkedHashMap::new, Collectors.counting())).forEach((item, count) -> {
                if (count > 1L) {
                    tooltip.add((Component)SomeAssemblyRequired.translate("tooltip.ingredient_count", item, count).withStyle(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)item.withStyle(ChatFormatting.GRAY));
                }
            });
        }
        FoodProperties food = this.getFoodProperties(stack, null);
        if (ModCompat.isFarmersDelightLoaded() && food != null && !food.effects().isEmpty()) {
            if (((Boolean)ModConfig.client.listItemsInTooltip.get()).booleanValue()) {
                tooltip.add(CommonComponents.EMPTY);
            }
            TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)context.tickRate());
        }
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        boolean isPlacingOnTable = context.getLevel().getBlockState(context.getClickedPos().below()).is(ModTags.SANDWICHING_STATIONS);
        if (context.getPlayer() != null && (context.getPlayer().isShiftKeyDown() || isPlacingOnTable)) {
            return super.placeBlock(context, state);
        }
        return false;
    }

    public InteractionResult place(UseOnContext useOnContext, BlockPos pos, ItemStack sandwich) {
        BlockPos clickedPos = pos.below();
        BlockPlaceContext placeContext = BlockPlaceContext.at((BlockPlaceContext)new BlockPlaceContext(useOnContext), (BlockPos)clickedPos, (Direction)Direction.UP);
        if (!placeContext.canPlace()) {
            return InteractionResult.FAIL;
        }
        if ((placeContext = this.updatePlacementContext(placeContext)) == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(placeContext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        SandwichContents contents = SandwichContents.get(sandwich);
        if (contents.isEmpty()) {
            return InteractionResult.FAIL;
        }
        int size = SandwichBlock.getSizeFromSandwich(contents);
        if (!this.placeBlock(placeContext, blockstate = (BlockState)blockstate.setValue((Property)SandwichBlock.SIZE, (Comparable)Integer.valueOf(size)))) {
            return InteractionResult.FAIL;
        }
        Level level = placeContext.getLevel();
        Player player = placeContext.getPlayer();
        BlockState placedState = level.getBlockState(pos);
        if (placedState.is(blockstate.getBlock())) {
            this.updateCustomBlockEntityTag(pos, level, player, sandwich, placedState);
            SandwichItem.updateBlockEntityComponents(level, pos, sandwich);
            placedState.getBlock().setPlacedBy(level, pos, placedState, (LivingEntity)player, sandwich);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, pos, sandwich);
            }
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, pos);
        SoundType soundType = placedState.getSoundType((LevelReader)level, pos, (Entity)player);
        if (player != null) {
            level.playSound(player, pos, this.getPlaceSound(placedState, level, pos, player), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        }
        if (player == null || !player.getAbilities().instabuild) {
            sandwich.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private static void updateBlockEntityComponents(Level level, BlockPos pos, ItemStack stack) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity != null) {
            blockentity.applyComponentsFromItemStack(stack);
            blockentity.setChanged();
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        SandwichContents sandwich = SandwichContents.get(stack);
        for (ItemStack item : sandwich) {
            Ingredients.applyIngredientBehaviours(item, entity);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (sandwich.isBurger()) {
                player.awardStat((ResourceLocation)ModStatistics.BURGERS_EATEN.get());
            } else {
                player.awardStat((ResourceLocation)ModStatistics.SANDWICHES_EATEN.get());
            }
            this.triggerAdvancements(stack, player);
        }
        return super.finishUsingItem(stack, world, entity);
    }

    private void triggerAdvancements(ItemStack stack, ServerPlayer player) {
        SandwichContents sandwich = SandwichContents.get(stack);
        if (sandwich.isBurger()) {
            if (player.getStats().getValue(Stats.CUSTOM.get((Object)((ResourceLocation)ModStatistics.BURGERS_EATEN.get()))) >= 1000) {
                ((PlayerTrigger)ModAdvancementTriggers.CONSUME_1000_BURGERS.get()).trigger(player);
            }
        } else if (player.getStats().getValue(Stats.CUSTOM.get((Object)((ResourceLocation)ModStatistics.SANDWICHES_EATEN.get()))) >= 1000) {
            ((PlayerTrigger)ModAdvancementTriggers.CONSUME_1000_SANDWICHES.get()).trigger(player);
        }
    }

    public Component getName(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            return super.getName(stack);
        }
        return SandwichNameHelper.getSandwichDisplayName(stack);
    }
}

