/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.create.recipe.deployer;

import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.config.ModConfig;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.item.sandwich.SandwichContents;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModTags;

public class SandwichDeployingRecipe {
    private static final ResourceLocation RECIPE_ID = SomeAssemblyRequired.id("sandwich_deploying");

    public static Optional<RecipeHolder<DeployerApplicationRecipe>> createRecipe(RecipeWrapper inventory) {
        if (!SandwichDeployingRecipe.matches(inventory)) {
            return Optional.empty();
        }
        return Optional.of(SandwichDeployingRecipe.createRecipe(inventory.getItem(0), inventory.getItem(1)));
    }

    public static boolean matches(RecipeWrapper inventory) {
        ItemStack item = inventory.getItem(0);
        if (item.isEmpty() || !item.is(ModTags.SANDWICH_BREAD) && !item.is((Item)ModItems.SANDWICH.get())) {
            return false;
        }
        ItemStack ingredient = inventory.getItem(1);
        if (!Ingredients.canAddToSandwich(ingredient) || ingredient.is((Item)ModItems.SANDWICH.get())) {
            return false;
        }
        return (Integer)ModConfig.server.maximumSandwichHeight.get() >= Ingredients.getHeight(ingredient) + SandwichContents.maybeGet(item).map(SandwichContents::getTotalHeight).orElse(Ingredients.getHeight(item));
    }

    public static RecipeHolder<DeployerApplicationRecipe> createRecipe(ItemStack sandwich, ItemStack ingredient) {
        sandwich = sandwich.copy();
        sandwich.setCount(1);
        ingredient = ingredient.copy();
        ingredient.setCount(1);
        ItemStack container = ingredient.hasCraftingRemainingItem() ? ItemStack.EMPTY : Ingredients.getFood(ingredient, null).usingConvertsTo().orElse(ItemStack.EMPTY);
        ItemStack result = SandwichItem.of(sandwich, ingredient);
        DeployerApplicationRecipe recipe = (DeployerApplicationRecipe)((ItemApplicationRecipe.Builder)new ItemApplicationRecipe.Builder(DeployerApplicationRecipe::new, RECIPE_ID).withItemOutputs(new ProcessingOutput[]{new ProcessingOutput(result, 1.0f), container.isEmpty() ? ProcessingOutput.EMPTY : new ProcessingOutput(container, 1.0f)})).build();
        return new RecipeHolder(RECIPE_ID, (Recipe)recipe);
    }
}

