/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetStewEffectFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.data.providers.LootTables;
import someassemblyrequired.loot.RollLootTableModifier;
import someassemblyrequired.loot.SandwichLootEnabledCondition;
import someassemblyrequired.registry.ModItems;

public class LootModifiers
extends GlobalLootModifierProvider {
    protected final List<Builder> lootBuilders = new ArrayList<Builder>();

    public LootModifiers(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries, "someassemblyrequired");
    }

    private void addLoot() {
        this.addSandwich((ResourceKey<LootTable>)BuiltInLootTables.UNDERWATER_RUIN_BIG, (Holder<Potion>)Potions.TURTLE_MASTER);
        this.addSandwich((ResourceKey<LootTable>)BuiltInLootTables.UNDERWATER_RUIN_SMALL, (Holder<Potion>)Potions.WATER);
        this.addSandwich((ResourceKey<LootTable>)BuiltInLootTables.BURIED_TREASURE, (Holder<Potion>)Potions.WATER_BREATHING);
        this.addSandwich((ResourceKey<LootTable>)BuiltInLootTables.END_CITY_TREASURE, Items.CHORUS_FRUIT);
        this.addSandwich((ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT, (Holder<Potion>)Potions.NIGHT_VISION);
        this.addSandwich((ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON, (Item)ModItems.GOLDEN_APPLE_SLICES.get());
        this.addSandwich((ResourceKey<LootTable>)BuiltInLootTables.NETHER_BRIDGE, (Holder<Potion>)Potions.FIRE_RESISTANCE);
        this.addSandwich((ResourceKey<LootTable>)BuiltInLootTables.ANCIENT_CITY, (Holder<Potion>)Potions.REGENERATION);
        this.builder((ResourceKey<LootTable>)BuiltInLootTables.SHIPWRECK_SUPPLY, 0.05).getLootPool().add(LootTables.sandwich(LootTables.item(Items.SUSPICIOUS_STEW).apply((LootItemFunction.Builder)SetStewEffectFunction.stewEffect().withEffect(MobEffects.NIGHT_VISION, (NumberProvider)UniformGenerator.between((float)7.0f, (float)10.0f)).withEffect(MobEffects.JUMP, (NumberProvider)UniformGenerator.between((float)7.0f, (float)10.0f)).withEffect(MobEffects.WEAKNESS, (NumberProvider)UniformGenerator.between((float)6.0f, (float)8.0f)).withEffect(MobEffects.BLINDNESS, (NumberProvider)UniformGenerator.between((float)5.0f, (float)7.0f)).withEffect(MobEffects.POISON, (NumberProvider)UniformGenerator.between((float)10.0f, (float)20.0f)).withEffect(MobEffects.SATURATION, (NumberProvider)UniformGenerator.between((float)7.0f, (float)10.0f)))));
        this.builder((ResourceKey<LootTable>)BuiltInLootTables.SPAWN_BONUS_CHEST, 1.0).getLootPool().add((LootPoolEntryContainer.Builder)LootTables.sandwich(Items.HONEY_BOTTLE).apply(LootTables.count(3, 8)));
    }

    private void addSandwich(ResourceKey<LootTable> lootTable, Item item) {
        this.builder(lootTable, 0.05).getLootPool().add(LootTables.sandwich(item));
    }

    private void addSandwich(ResourceKey<LootTable> lootTable, Holder<Potion> potion) {
        this.builder(lootTable, 0.05).getLootPool().add(LootTables.sandwich(potion));
    }

    protected Builder builder(ResourceKey<LootTable> lootTable, double chance) {
        Builder builder = new Builder(lootTable.location().getPath());
        builder.lootModifierCondition(LootTableIdCondition.builder((ResourceLocation)lootTable.location()).build());
        builder.lootModifierCondition(SandwichLootEnabledCondition.sandwichLootEnabled());
        if (chance != 1.0) {
            builder.lootPoolCondition(LootItemRandomChanceCondition.randomChance((float)((float)chance)));
        }
        this.lootBuilders.add(builder);
        return builder;
    }

    protected void start() {
        this.addLoot();
        for (Builder lootBuilder : this.lootBuilders) {
            this.add(lootBuilder.getName(), (IGlobalLootModifier)lootBuilder.build(), new ICondition[0]);
        }
        for (ResourceKey lootTable : List.of(BuiltInLootTables.VILLAGE_DESERT_HOUSE, BuiltInLootTables.VILLAGE_SAVANNA_HOUSE, BuiltInLootTables.VILLAGE_PLAINS_HOUSE, BuiltInLootTables.VILLAGE_TAIGA_HOUSE, BuiltInLootTables.VILLAGE_SNOWY_HOUSE)) {
            ArrayList<LootItemCondition> conditions = new ArrayList<LootItemCondition>();
            conditions.add(SandwichLootEnabledCondition.sandwichLootEnabled());
            conditions.add(LootTableIdCondition.builder((ResourceLocation)lootTable.location()).build());
            this.add("inject/" + lootTable.location().getPath(), (IGlobalLootModifier)new RollLootTableModifier(conditions.toArray(new LootItemCondition[0]), LootTables.VILLAGE_SANDWICH), new ICondition[0]);
        }
    }

    protected static class Builder {
        private final String lootTableName;
        private final LootPool.Builder lootPool = LootPool.lootPool();
        private final List<LootItemCondition> conditions;
        private LootContextParamSet paramSet = LootContextParamSets.CHEST;

        private Builder(String lootTableName) {
            this.lootTableName = "inject/" + lootTableName;
            this.conditions = new ArrayList<LootItemCondition>();
        }

        private RollLootTableModifier build() {
            return new RollLootTableModifier(this.conditions.toArray(new LootItemCondition[0]), SomeAssemblyRequired.key(Registries.LOOT_TABLE, this.getName()));
        }

        protected LootTable.Builder createLootTable() {
            return new LootTable.Builder().withPool(this.lootPool);
        }

        public LootContextParamSet getParameterSet() {
            return this.paramSet;
        }

        public LootPool.Builder getLootPool() {
            return this.lootPool;
        }

        protected String getName() {
            return this.lootTableName;
        }

        private Builder parameterSet(LootContextParamSet paramSet) {
            this.paramSet = paramSet;
            return this;
        }

        private Builder lootPoolCondition(LootItemCondition.Builder condition) {
            this.lootPool.when(condition);
            return this;
        }

        private Builder lootModifierCondition(LootItemCondition condition) {
            this.conditions.add(condition);
            return this;
        }
    }
}

