/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.providers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.data.providers.Ingredients;
import someassemblyrequired.registry.ModItems;

public class ItemModels
extends ItemModelProvider {
    public ItemModels(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "someassemblyrequired", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = BuiltInRegistries.ITEM.stream().filter(item -> BuiltInRegistries.ITEM.getKey(item).getNamespace().equals("someassemblyrequired")).collect(Collectors.toSet());
        ItemModels.removeAll(items, (ItemLike)ModItems.SANDWICH.get());
        this.addSandwich();
        ItemModels.removeAll(items, (ItemLike)ModItems.SPREAD.get());
        items.removeIf(item -> Ingredients.MODEL_OVERRIDES.contains(BuiltInRegistries.ITEM.wrapAsHolder(item)));
        this.addSpread();
        ItemModels.removeAll(items, (ItemLike)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get());
        this.addGeneratedModel("enchanted_golden_apple_slices", this.prefixItem("golden_apple_slices"));
        ItemModels.removeAll(items, (T item) -> item instanceof BlockItem).forEach(block -> this.withExistingParent(BuiltInRegistries.ITEM.getKey(block).getPath(), this.prefixBlock(BuiltInRegistries.ITEM.getKey(block).getPath())));
        items.forEach(this::addGeneratedModel);
    }

    private void addSpread() {
        HashMap<Holder<Item>, ItemModelBuilder> customModels = new HashMap<Holder<Item>, ItemModelBuilder>();
        this.addCustomIngredientModels(customModels);
        ItemModelBuilder spreadModel = this.addGeneratedModel((Item)ModItems.SPREAD.get());
        for (int i = 0; i < Ingredients.MODEL_OVERRIDES.size(); ++i) {
            Holder<Item> item = Ingredients.MODEL_OVERRIDES.get(i);
            if ("someassemblyrequired".equals(item.getKey().location().getNamespace())) {
                this.addGeneratedModel((Item)item.value());
            }
            String path = this.getIngredientPath(item);
            Object model = customModels.containsKey(item) ? (ModelFile)customModels.get(item) : (this.existingFileHelper.exists(this.prefixItem(path), PackType.CLIENT_RESOURCES, ".json", "models") ? new ModelFile.UncheckedModelFile(this.prefixItem(path)) : this.addGeneratedModel(path, this.prefixItem(path)));
            spreadModel.override().model(model).predicate(ResourceLocation.parse((String)"custom_model_data"), (float)(i + 1)).end();
        }
    }

    private void addCustomIngredientModels(HashMap<Holder<Item>, ItemModelBuilder> customModels) {
        this.addBeefPattyModels(customModels);
        String path = this.getIngredientPath(Items.POTATO);
        ResourceLocation texture = this.prefixItem(path);
        customModels.put((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.POTATO), (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).texture("potato", texture)).element().from(5.0f, 0.0f, 4.0f).to(11.0f, 5.0f, 12.0f).face(Direction.NORTH).uvs(0.0f, 11.0f, 6.0f, 16.0f).end().face(Direction.EAST).uvs(8.0f, 0.0f, 16.0f, 5.0f).end().face(Direction.SOUTH).uvs(6.0f, 11.0f, 12.0f, 16.0f).end().face(Direction.WEST).uvs(0.0f, 0.0f, 8.0f, 5.0f).end().face(Direction.UP).uvs(0.0f, 5.0f, 8.0f, 11.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end().face(Direction.DOWN).uvs(8.0f, 5.0f, 16.0f, 11.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().faces((direction, builder) -> builder.texture("#potato")).end());
        path = this.getIngredientPath((Item)ModItems.BURGER_BUN.get());
        texture = this.prefixItem(path);
        customModels.put((Holder<Item>)ModItems.BURGER_BUN, (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).texture("burger_bun", texture)).element().from(2.0f, 0.0f, 2.0f).to(14.0f, 6.0f, 14.0f).face(Direction.NORTH).uvs(6.0f, 12.0f, 12.0f, 15.0f).end().face(Direction.EAST).uvs(0.0f, 12.0f, 6.0f, 15.0f).end().face(Direction.SOUTH).uvs(6.0f, 6.0f, 12.0f, 9.0f).end().face(Direction.WEST).uvs(6.0f, 9.0f, 12.0f, 12.0f).end().face(Direction.UP).uvs(0.0f, 0.0f, 6.0f, 6.0f).end().face(Direction.DOWN).uvs(0.0f, 6.0f, 6.0f, 12.0f).end().faces((direction, builder) -> builder.texture("#burger_bun")).end());
        path = this.getIngredientPath((Item)ModItems.BURGER_BUN_BOTTOM.get());
        customModels.put((Holder<Item>)ModItems.BURGER_BUN_BOTTOM, (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).texture("burger_bun", texture)).element().from(2.0f, 0.0f, 2.0f).to(14.0f, 2.0f, 14.0f).face(Direction.NORTH).uvs(6.0f, 14.0f, 12.0f, 15.0f).end().face(Direction.EAST).uvs(0.0f, 14.0f, 6.0f, 15.0f).end().face(Direction.SOUTH).uvs(6.0f, 8.0f, 12.0f, 9.0f).end().face(Direction.WEST).uvs(6.0f, 11.0f, 12.0f, 12.0f).end().face(Direction.UP).uvs(6.0f, 0.0f, 12.0f, 6.0f).end().face(Direction.DOWN).uvs(0.0f, 6.0f, 6.0f, 12.0f).end().faces((direction, builder) -> builder.texture("#burger_bun")).end());
        path = this.getIngredientPath((Item)ModItems.BURGER_BUN_TOP.get());
        customModels.put((Holder<Item>)ModItems.BURGER_BUN_TOP, (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).texture("burger_bun", texture)).element().from(2.0f, 0.0f, 2.0f).to(14.0f, 4.0f, 14.0f).face(Direction.NORTH).uvs(6.0f, 12.0f, 12.0f, 14.0f).end().face(Direction.EAST).uvs(0.0f, 12.0f, 6.0f, 14.0f).end().face(Direction.SOUTH).uvs(6.0f, 6.0f, 12.0f, 8.0f).end().face(Direction.WEST).uvs(6.0f, 9.0f, 12.0f, 11.0f).end().face(Direction.UP).uvs(0.0f, 0.0f, 6.0f, 6.0f).end().face(Direction.DOWN).uvs(6.0f, 0.0f, 12.0f, 6.0f).end().faces((direction, builder) -> builder.texture("#burger_bun")).end());
    }

    private void addBeefPattyModels(HashMap<Holder<Item>, ItemModelBuilder> customModels) {
        for (Holder item : Arrays.asList(BuiltInRegistries.ITEM.wrapAsHolder((Object)((Item)vectorwing.farmersdelight.common.registry.ModItems.BEEF_PATTY.get())), BuiltInRegistries.ITEM.wrapAsHolder((Object)((Item)vectorwing.farmersdelight.common.registry.ModItems.MINCED_BEEF.get())), Ingredients.reference("minersdelight", "vegan_patty"))) {
            String path = this.getIngredientPath((Holder<Item>)item);
            ResourceLocation texture = this.prefixItem(path);
            customModels.put((Holder<Item>)item, (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).texture("beef_patty", texture)).element().from(2.0f, 0.0f, 2.0f).to(14.0f, 2.0f, 14.0f).face(Direction.NORTH).uvs(2.0f, 0.0f, 14.0f, 2.0f).rotation(ModelBuilder.FaceRotation.UPSIDE_DOWN).end().face(Direction.EAST).uvs(14.0f, 2.0f, 16.0f, 14.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).end().face(Direction.SOUTH).uvs(2.0f, 14.0f, 14.0f, 16.0f).rotation(ModelBuilder.FaceRotation.ZERO).end().face(Direction.WEST).uvs(0.0f, 2.0f, 2.0f, 14.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).end().face(Direction.UP).uvs(2.0f, 2.0f, 14.0f, 14.0f).end().face(Direction.DOWN).uvs(2.0f, 2.0f, 14.0f, 14.0f).end().faces((direction, builder) -> builder.texture("#beef_patty")).end());
        }
    }

    private String getIngredientPath(Holder<Item> item) {
        return "ingredient/" + item.getKey().location().toString().replace(':', '/');
    }

    private String getIngredientPath(Item item) {
        return "ingredient/" + this.getItemPath(item);
    }

    private String getItemPath(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).toString().replace(':', '/');
    }

    private String getItemName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    private void addSandwich() {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.getItemName((Item)ModItems.SANDWICH.get()))).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).texture("particle", this.prefixItem("bread_slice"))).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 45.0f, 0.0f).scale(0.8f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 180.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.HEAD).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 0.5f, 0.0f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, -4.0f, 0.0f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 315.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.55f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 315.0f, 0.0f).translation(0.0f, 1.0f, 0.0f).scale(0.5f).end().end();
    }

    private ResourceLocation prefixBlock(String path) {
        return SomeAssemblyRequired.id("block/" + path);
    }

    private ResourceLocation prefixItem(String path) {
        return SomeAssemblyRequired.id("item/" + path);
    }

    private ItemModelBuilder addGeneratedModel(Item item) {
        String name = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("item/" + name, "item/generated")).texture("layer0", this.prefixItem(name));
    }

    private ItemModelBuilder addGeneratedModel(String name, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", texture);
    }

    private static void removeAll(Set<Item> set, ItemLike ... items) {
        Set result = Arrays.stream(items).map(ItemLike::asItem).collect(Collectors.toSet());
        set.removeAll(result);
    }

    private static <T> Collection<T> removeAll(Set<T> set, Predicate<T> pred) {
        Set result = set.stream().filter(pred).collect(Collectors.toSet());
        set.removeAll(result);
        if (result.size() <= 0) {
            throw new IllegalArgumentException();
        }
        return result;
    }
}

