/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.world;

import com.google.common.collect.HashMultimap;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirPolygon;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.ReservoirRegionDataStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class FeatureReservoir
extends Feature<NoneFeatureConfiguration> {
    public static HashMultimap<ResourceKey<Level>, ChunkPos> generatedReservoirChunks = HashMultimap.create();

    public FeatureReservoir() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel reader = pContext.level();
        BlockPos pos = pContext.origin();
        ReservoirHandler.initGenerator(reader);
        ServerLevel level = reader.getLevel();
        ChunkPos chunkPos = reader.getChunk(pos).getPos();
        ResourceKey dimension = level.dimension();
        if (generatedReservoirChunks.containsEntry((Object)dimension, (Object)chunkPos)) {
            return false;
        }
        FeatureReservoir.scanChunkForNewReservoirs(level, chunkPos, pContext.random());
        generatedReservoirChunks.put((Object)dimension, (Object)chunkPos);
        return true;
    }

    public static void scanChunkForNewReservoirs(ServerLevel world, ChunkPos chunkPos, RandomSource randomSource) {
        int chunkX = chunkPos.getMinBlockX();
        int chunkZ = chunkPos.getMinBlockZ();
        ResourceKey dimension = world.dimension();
        ReservoirRegionDataStorage storage = ReservoirRegionDataStorage.get();
        for (int j = 0; j < 16; ++j) {
            for (int i = 0; i < 16; ++i) {
                ReservoirPolygon reservoirPolygon;
                int x = chunkX + i;
                int z = chunkZ + j;
                if (ReservoirHandler.getValueOf((Level)world, x, z) <= -1.0) continue;
                ColumnPos current = new ColumnPos(x, z);
                if (storage.existsAt(current)) {
                    return;
                }
                Holder biome = world.getBiome(new BlockPos(x, 64, z));
                RecipeHolder<ReservoirType> type = null;
                int totalWeight = ReservoirHandler.getTotalWeight((ResourceKey<Level>)dimension, (Holder<Biome>)biome);
                if (totalWeight <= 0) continue;
                int weight = Math.abs(randomSource.nextInt() % totalWeight);
                for (RecipeHolder<ReservoirType> holder : ReservoirType.map.values()) {
                    ReservoirType res = (ReservoirType)holder.value();
                    if (!res.getDimensions().isValid((ResourceKey<Level>)dimension) || !res.getBiomes().isValid((Holder<Biome>)biome) || (weight -= res.weight) >= 0) continue;
                    type = holder;
                    break;
                }
                if (type == null || (reservoirPolygon = ReservoirPolygon.make((Level)world, new ColumnPos(x, z))).isEmpty()) continue;
                int amount = (int)Mth.lerp((float)randomSource.nextFloat(), (float)((ReservoirType)type.value()).minSize, (float)((ReservoirType)type.value()).maxSize);
                Reservoir reservoir = new Reservoir(reservoirPolygon, type, amount);
                storage.addReservoir((ResourceKey<Level>)dimension, reservoir);
            }
        }
    }
}

