/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.projector;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.utils.TemplateWorldCreator;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MultiblockProjection {
    final MultiblockHandler.IMultiblock multiblock;
    final Level realWorld;
    @Nullable
    final Level templateWorld;
    final StructurePlaceSettings settings = new StructurePlaceSettings();
    final Int2ObjectMap<List<StructureTemplate.StructureBlockInfo>> layers = new Int2ObjectArrayMap();
    final BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
    final int blockcount;
    boolean isDirty = true;

    public MultiblockProjection(@Nonnull Level world, @Nonnull MultiblockHandler.IMultiblock multiblock) {
        Objects.requireNonNull(world, "World cannot be null!");
        Objects.requireNonNull(multiblock, "Multiblock cannot be null!");
        this.multiblock = multiblock;
        this.realWorld = world;
        List blocks = multiblock.getStructure(world);
        this.templateWorld = world.isClientSide ? ((TemplateWorldCreator)TemplateWorldCreator.CREATOR.get()).makeWorld(blocks, pos -> true, world.registryAccess()) : null;
        this.blockcount = blocks.size();
        blocks.forEach(info -> {
            List list = (List)this.layers.computeIfAbsent(info.pos().getY(), ArrayList::new);
            list.add(info);
        });
    }

    public MultiblockProjection setRotation(Rotation rotation) {
        if (this.settings.getRotation() != rotation) {
            this.settings.setRotation(rotation);
            this.isDirty = true;
        }
        return this;
    }

    public MultiblockProjection setFlip(boolean mirror) {
        Mirror m;
        Mirror mirror2 = m = mirror ? Mirror.FRONT_BACK : Mirror.NONE;
        if (this.settings.getMirror() != m) {
            this.settings.setMirror(m);
            this.isDirty = true;
        }
        return this;
    }

    public void reset() {
        this.settings.setRotation(Rotation.NONE);
        this.settings.setMirror(Mirror.NONE);
        this.offset.set(0, 0, 0);
    }

    public int getBlockCount() {
        return this.blockcount;
    }

    public int getLayerCount() {
        return this.layers.size();
    }

    public int getLayerSize(int layer) {
        if (layer < 0 || layer >= this.layers.size()) {
            return 0;
        }
        return ((List)this.layers.get(layer)).size();
    }

    @Nullable
    public Level getTemplateWorld() {
        return this.templateWorld;
    }

    public MultiblockHandler.IMultiblock getMultiblock() {
        return this.multiblock;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiblockProjection) {
            MultiblockProjection other = (MultiblockProjection)obj;
            return this.multiblock.getUniqueName().equals((Object)other.multiblock.getUniqueName()) && this.settings.getMirror() == other.settings.getMirror() && this.settings.getRotation() == other.settings.getRotation();
        }
        return false;
    }

    public boolean process(int layer, Predicate<Info> predicate) {
        this.updateData();
        List blocks = (List)this.layers.get(layer);
        for (StructureTemplate.StructureBlockInfo info : blocks) {
            if (!predicate.test(new Info(this, info))) continue;
            return true;
        }
        return false;
    }

    public boolean processAll(BiPredicate<Integer, Info> predicate) {
        this.updateData();
        for (int layer = 0; layer < this.getLayerCount(); ++layer) {
            List blocks = (List)this.layers.get(layer);
            for (StructureTemplate.StructureBlockInfo info : blocks) {
                if (!predicate.test(layer, new Info(this, info))) continue;
                return true;
            }
        }
        return false;
    }

    private void updateData() {
        if (!this.isDirty) {
            return;
        }
        this.isDirty = false;
        boolean mirrored = this.settings.getMirror() == Mirror.FRONT_BACK;
        Rotation rotation = this.settings.getRotation();
        Vec3i size = this.multiblock.getSize(this.realWorld);
        if (!mirrored) {
            switch (rotation) {
                case CLOCKWISE_90: {
                    this.offset.set(1 - size.getZ(), 0, 0);
                    break;
                }
                case CLOCKWISE_180: {
                    this.offset.set(1 - size.getX(), 0, 1 - size.getZ());
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.offset.set(0, 0, 1 - size.getX());
                    break;
                }
                default: {
                    this.offset.set(0, 0, 0);
                    break;
                }
            }
        } else {
            switch (rotation) {
                case NONE: {
                    this.offset.set(1 - size.getX(), 0, 0);
                    break;
                }
                case CLOCKWISE_90: {
                    this.offset.set(1 - size.getZ(), 0, 1 - size.getX());
                    break;
                }
                case CLOCKWISE_180: {
                    this.offset.set(0, 0, 1 - size.getZ());
                    break;
                }
                default: {
                    this.offset.set(0, 0, 0);
                }
            }
        }
        int x = (rotation.ordinal() % 2 == 0 ? size.getX() : size.getZ()) / 2;
        int z = (rotation.ordinal() % 2 == 0 ? size.getZ() : size.getX()) / 2;
        this.offset.setWithOffset((Vec3i)this.offset, x, 0, z);
    }

    public static final class Info {
        public final StructurePlaceSettings settings;
        public final MultiblockHandler.IMultiblock multiblock;
        public final BlockPos tPos;
        @Nullable
        public final Level templateWorld;
        public final StructureTemplate.StructureBlockInfo tBlockInfo;

        public Info(MultiblockProjection projection, StructureTemplate.StructureBlockInfo templateBlockInfo) {
            this.multiblock = projection.multiblock;
            this.templateWorld = projection.templateWorld;
            this.settings = projection.settings;
            this.tBlockInfo = templateBlockInfo;
            this.tPos = StructureTemplate.calculateRelativePosition((StructurePlaceSettings)this.settings, (BlockPos)templateBlockInfo.pos()).subtract((Vec3i)projection.offset);
        }

        public BlockState getModifiedState(Level realWorld, BlockPos realPos) {
            return this.tBlockInfo.state().mirror(this.settings.getMirror()).rotate((LevelAccessor)realWorld, realPos, this.settings.getRotation());
        }

        public BlockState getRawState() {
            return this.tBlockInfo.state();
        }
    }
}

