/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.inventory;

import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class MultiFluidTankFiltered
implements IFluidHandler,
IFluidTank {
    protected final List<FluidStack> fluids = new ArrayList<FluidStack>();
    protected final int capacity;
    protected final Predicate<FluidStack> validator;

    public MultiFluidTankFiltered(int capacity) {
        this(capacity, fs -> true);
    }

    public MultiFluidTankFiltered(int capacity, @Nonnull Predicate<FluidStack> validator) {
        this.capacity = capacity;
        this.validator = Objects.requireNonNull(validator);
    }

    public MultiFluidTankFiltered readFromNBT(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        if (tag.contains("fluids", 9)) {
            this.fluids.clear();
            ListTag tagList = tag.getList("fluids", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                FluidStack fs = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tagList.getCompound(i));
                if (fs.isEmpty()) continue;
                this.fluids.add(fs);
            }
        }
        return this;
    }

    @Nonnull
    public CompoundTag writeToNBT(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        ListTag tagList = new ListTag();
        for (FluidStack fs : this.fluids) {
            if (fs.isEmpty()) continue;
            tagList.add((Object)fs.save(provider));
        }
        tag.put("fluids", (Tag)tagList);
        return tag;
    }

    public GenericContainerData<List<FluidStack>> getContainerData() {
        GetterAndSetter getterAndSetter = new GetterAndSetter(() -> this.fluids, fList -> {
            this.fluids.clear();
            if (!fList.isEmpty()) {
                this.fluids.addAll((Collection<FluidStack>)fList);
            }
        });
        return new GenericContainerData(GenericDataSerializers.FLUID_STACKS, getterAndSetter);
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.fluids.isEmpty() ? FluidStack.EMPTY : this.fluids.getLast();
    }

    public int getFluidAmount() {
        int total = 0;
        for (FluidStack fs : this.fluids) {
            total += fs.getAmount();
        }
        return total;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isFluidValid(@Nonnull FluidStack fluid) {
        return this.validator.test(fluid);
    }

    public int getTanks() {
        return this.fluids.size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= this.fluids.size()) {
            return FluidStack.EMPTY;
        }
        return this.fluids.get(tank);
    }

    public int getTankCapacity(int tank) {
        if (tank < 0 || tank >= this.fluids.size()) {
            return this.capacity - this.getFluidAmount();
        }
        return this.fluids.get(tank).getAmount();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack fluid) {
        return this.isFluidValid(fluid);
    }

    public int fill(@Nonnull FluidStack fluid, @Nonnull IFluidHandler.FluidAction action) {
        int filled = Math.min(fluid.getAmount(), this.capacity - this.getFluidAmount());
        if (action.simulate()) {
            return filled;
        }
        for (FluidStack fs : this.fluids) {
            if (!FluidStack.isSameFluidSameComponents((FluidStack)fs, (FluidStack)fluid)) continue;
            fs.grow(filled);
            return filled;
        }
        this.fluids.addFirst(fluid.copyWithAmount(filled));
        return filled;
    }

    @Nonnull
    public FluidStack drain(@Nonnull FluidStack fluid, @Nonnull IFluidHandler.FluidAction action) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this.fluids.stream().filter(fs -> FluidStack.isSameFluidSameComponents((FluidStack)fs, (FluidStack)fluid)).findFirst().map(fs -> {
            int amount = Math.min(fluid.getAmount(), fs.getAmount());
            if (action.execute()) {
                fs.shrink(amount);
                if (fs.getAmount() <= 0) {
                    fs.shrink(amount);
                    if (fs.getAmount() <= 0) {
                        this.fluids.removeIf(f -> f == fs);
                    }
                }
            }
            return fluid.copyWithAmount(amount);
        }).orElse(FluidStack.EMPTY);
    }

    @Nonnull
    public FluidStack drain(int drainAmount, @Nonnull IFluidHandler.FluidAction action) {
        return this.drain(this.getFluid().copyWithAmount(drainAmount), action);
    }
}

