/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.inventory;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;

public class EnumInventory<E extends Enum<E>> {
    private final NonNullList<ItemStack> inventory;

    public EnumInventory(Class<E> c) {
        this.inventory = NonNullList.withSize((int)((Enum[])c.getEnumConstants()).length, (Object)ItemStack.EMPTY);
    }

    public void save(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.put("inventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.inventory, (HolderLookup.Provider)provider));
    }

    public void load(CompoundTag nbt, HolderLookup.Provider provider) {
        NonNullList list = NonNullList.withSize((int)this.size(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("inventory"), (NonNullList)list, (HolderLookup.Provider)provider);
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = ItemStack.EMPTY;
            if (i < list.size()) {
                stack = (ItemStack)list.get(i);
            }
            this.inventory.set(i, (Object)stack);
        }
    }

    public int size() {
        return this.inventory.size();
    }

    public NonNullList<ItemStack> getInternal() {
        return this.inventory;
    }

    public ItemStack set(E inv, ItemStack stack) {
        return (ItemStack)this.inventory.set(((Enum)inv).ordinal(), (Object)stack);
    }

    public ItemStack get(E inv) {
        return (ItemStack)this.inventory.get(((Enum)inv).ordinal());
    }
}

