/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.jei;

import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

class TooltipHandler
implements IRecipeSlotRichTooltipCallback {
    private final Map<Item, Float> map = new HashMap<Item, Float>();

    public TooltipHandler(List<StackWithChance> itemOutput) {
        if (itemOutput.isEmpty()) {
            return;
        }
        itemOutput.forEach(stack -> this.map.put(stack.stack().get().getItem(), Float.valueOf(stack.chance())));
    }

    public TooltipHandler(@Nonnull StackWithChance stack) {
        this.map.put(stack.stack().get().getItem(), Float.valueOf(stack.chance()));
    }

    public void onRichTooltip(IRecipeSlotView recipeSlotView, @Nonnull ITooltipBuilder tooltip) {
        recipeSlotView.getDisplayedIngredient().ifPresent(type -> {
            Object patt0$temp = type.getIngredient();
            if (!(patt0$temp instanceof ItemStack)) {
                return;
            }
            ItemStack stack = (ItemStack)patt0$temp;
            Float t = this.map.get(stack.getItem());
            if (t != null) {
                double chance = t.doubleValue();
                MutableComponent text = Component.translatable((String)"desc.immersivepetroleum.compat.jei.distillation.byproduct").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE});
                tooltip.add((FormattedText)text);
                tooltip.add((FormattedText)this.toTextComponent(chance));
            }
        });
    }

    private Component toTextComponent(double chance) {
        return Component.literal((String)String.format(Locale.ENGLISH, "%.2f%%", 100.0 * chance)).withStyle(ChatFormatting.GRAY);
    }
}

