/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.jei;

import flaxbeard.immersivepetroleum.api.crafting.HighPressureRefineryRecipe;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.compat.jei.IPRecipeCategory;
import flaxbeard.immersivepetroleum.common.util.compat.jei.JEIStuff;
import flaxbeard.immersivepetroleum.common.util.compat.jei.TooltipHandler;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HighPressureRefineryRecipeCategory
extends IPRecipeCategory<HighPressureRefineryRecipe> {
    public static final ResourceLocation ID = ResourceUtils.ip("hydrotreater");

    public HighPressureRefineryRecipeCategory(IGuiHelper guiHelper) {
        super(HighPressureRefineryRecipe.class, guiHelper, ID, "block.immersivepetroleum.hydrotreater");
        ResourceLocation background = ResourceUtils.ip("textures/gui/jei/hydrotreater.png");
        this.setBackground(guiHelper.createDrawable(background, 0, 0, 113, 75));
        this.setIcon(new ItemStack((ItemLike)IPContent.Multiblock.HYDROTREATER.block().get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HighPressureRefineryRecipe recipe, @Nonnull IFocusGroup focuses) {
        int primaryInputAmount = recipe.getPrimaryInputFluid().amount();
        int secondaryInputAmount = recipe.getSecondaryInputFluid() != null ? recipe.getSecondaryInputFluid().amount() : 0;
        int outputAmount = recipe.getOutputFluid().getAmount();
        int guiTankSize = Math.min(Math.max(Math.max(primaryInputAmount, secondaryInputAmount), outputAmount), 1000);
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 3).setFluidRenderer((long)guiTankSize, false, 20, 51).setOverlay((IDrawable)JEIStuff.tankOverlay, 0, 0).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(recipe.getPrimaryInputFluid().getFluids()));
        IRecipeSlotBuilder secondary = builder.addSlot(RecipeIngredientRole.INPUT, 25, 3).setFluidRenderer((long)guiTankSize, false, 20, 51).setOverlay((IDrawable)JEIStuff.tankOverlay, 0, 0);
        if (recipe.getSecondaryInputFluid() != null) {
            secondary.addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(recipe.getSecondaryInputFluid().getFluids()));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 71, 3).setFluidRenderer((long)guiTankSize, false, 20, 51).setOverlay((IDrawable)JEIStuff.tankOverlay, 0, 0).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluid());
        if (recipe.getSecondaryItem() != null) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 94, 21).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getSecondaryItem().stack().get())).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)new TooltipHandler(recipe.getSecondaryItem()));
        }
    }

    public void draw(HighPressureRefineryRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        IDrawable background = this.getBackground();
        int bWidth = background.getWidth();
        int bHeight = background.getHeight();
        Font font = MCUtil.getFont();
        int time = recipe.getTotalProcessTime();
        int energy = recipe.getTotalProcessEnergy() / recipe.getTotalProcessTime();
        guiGraphics.pose().pushPose();
        String text0 = I18n.get((String)"desc.immersiveengineering.info.ift", (Object[])new Object[]{Utils.fDecimal(energy)});
        int n = bWidth / 2 - font.width(text0) / 2;
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, text0, n, bHeight - 9 * 2, -1, false);
        String text1 = I18n.get((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.fDecimal((double)time / 20.0)});
        int n2 = bWidth / 2 - font.width(text1) / 2;
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, text1, n2, bHeight - 9, -1, false);
        guiGraphics.pose().popPose();
    }
}

