/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.jei;

import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import flaxbeard.immersivepetroleum.api.crafting.DistillationTowerRecipe;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.compat.jei.IPRecipeCategory;
import flaxbeard.immersivepetroleum.common.util.compat.jei.JEIStuff;
import flaxbeard.immersivepetroleum.common.util.compat.jei.TooltipHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class DistillationRecipeCategory
extends IPRecipeCategory<DistillationTowerRecipe> {
    public static final ResourceLocation ID = ResourceUtils.ip("distillation");

    public DistillationRecipeCategory(IGuiHelper guiHelper) {
        super(DistillationTowerRecipe.class, guiHelper, ID, "block.immersivepetroleum.distillation_tower");
        ResourceLocation background = ResourceUtils.ip("textures/gui/jei/distillationtower.png");
        this.setBackground(guiHelper.createDrawable(background, 0, 0, 120, 77));
        this.setIcon(new ItemStack((ItemLike)IPContent.Multiblock.DISTILLATIONTOWER.block().get()));
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, DistillationTowerRecipe recipe, @Nonnull IFocusGroup focuses) {
        int outputTotal = 0;
        List list = recipe.getFluidOutputs();
        if (!list.isEmpty()) {
            for (FluidStack f : list) {
                outputTotal += f.getAmount();
            }
            int tW = 16;
            int tH = 47;
            int x0 = 47;
            int lastHeight = 52;
            for (int i = list.size() - 1; i >= 0; --i) {
                FluidStack f = (FluidStack)list.get(i);
                int height = (int)((float)tH * ((float)f.getAmount() / (float)outputTotal));
                IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x0, lastHeight - height).setFluidRenderer((long)f.getAmount(), false, tW, height).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)f);
                lastHeight -= height;
                if (i != 0) continue;
                slot.setOverlay((IDrawable)JEIStuff.tankOverlay, -2, -lastHeight + 3);
            }
        }
        if (recipe.getInputFluid() != null) {
            builder.addSlot(RecipeIngredientRole.INPUT, 11, 22).setFluidRenderer((long)outputTotal, false, 16, 47).setOverlay((IDrawable)JEIStuff.tankOverlay, -2, -2).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(recipe.getInputFluid().getFluids()));
        }
        IRecipeSlotBuilder itemOutput = builder.addSlot(RecipeIngredientRole.OUTPUT, 77, 37).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)new TooltipHandler(recipe.getItemOutput()));
        for (StackWithChance s : recipe.getItemOutput()) {
            itemOutput.addItemStack(s.stack().get());
        }
    }

    public void draw(@Nonnull DistillationTowerRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        IDrawable background = this.getBackground();
        int bWidth = background.getWidth();
        int bHeight = background.getHeight();
        Font font = MCUtil.getFont();
        int time = recipe.getTotalProcessTime();
        int energy = recipe.getTotalProcessEnergy() / time;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(23.0f, 0.0f, 0.0f);
        String text0 = I18n.get((String)"desc.immersiveengineering.info.ift", (Object[])new Object[]{Utils.fDecimal(energy)});
        int n = bWidth / 2 - font.width(text0) / 2;
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, text0, n, bHeight - 9 * 2, -1, false);
        String text1 = I18n.get((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.fDecimal((double)time / 20.0)});
        int n2 = bWidth / 2 - font.width(text1) / 2;
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, text1, n2, bHeight - 9, -1, false);
        guiGraphics.pose().popPose();
    }
}

