/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.jei;

import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.compat.jei.IPRecipeCategory;
import flaxbeard.immersivepetroleum.common.util.compat.jei.JEIStuff;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CokerUnitRecipeCategory
extends IPRecipeCategory<CokerUnitRecipe> {
    public static final ResourceLocation ID = ResourceUtils.ip("cokerunit");

    public CokerUnitRecipeCategory(IGuiHelper guiHelper) {
        super(CokerUnitRecipe.class, guiHelper, ID, "block.immersivepetroleum.coker_unit");
        ResourceLocation background = ResourceUtils.ip("textures/gui/jei/coker.png");
        this.setBackground(guiHelper.createDrawable(background, 0, 0, 150, 77));
        this.setIcon(new ItemStack((ItemLike)IPContent.Multiblock.COKERUNIT.block().get()));
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, CokerUnitRecipe recipe, @Nonnull IFocusGroup focuses) {
        int inputAmount = recipe.getInputFluid().amount();
        int outputAmount = recipe.getOutputFluid().getAmount();
        int guiTankSize = Math.max(inputAmount, outputAmount);
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).setFluidRenderer((long)guiTankSize, false, 20, 51).setOverlay((IDrawable)JEIStuff.tankOverlay, 0, 0).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, Arrays.asList(recipe.getInputFluid().getFluids()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 2).setFluidRenderer((long)guiTankSize, false, 20, 51).setOverlay((IDrawable)JEIStuff.tankOverlay, 0, 0).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluid());
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 58).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Arrays.asList(recipe.getInputItem().getMatchingStacks()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 52, 58).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(recipe.getOutputItem()));
    }

    public void draw(CokerUnitRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        IDrawable background = this.getBackground();
        int bWidth = background.getWidth();
        int bHeight = background.getHeight();
        Font font = MCUtil.getFont();
        int time = (recipe.getTotalProcessTime() + 2 + 5) * recipe.getInputItem().getCount();
        int energy = recipe.getTotalProcessEnergy() / recipe.getTotalProcessTime();
        guiGraphics.pose().pushPose();
        String text0 = I18n.get((String)"desc.immersiveengineering.info.ift", (Object[])new Object[]{Utils.fDecimal(energy)});
        int n = bWidth - 5 - font.width(text0);
        int n2 = bHeight / 3;
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, text0, n, n2 + 9, -1, false);
        String text1 = I18n.get((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.fDecimal((double)time / 20.0)});
        int n3 = bWidth - 10 - font.width(text1);
        int n4 = bHeight / 3;
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, text1, n3, n4 + 9 * 2, -1, false);
        guiGraphics.pose().popPose();
    }
}

