/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;

public class Utils {
    static final DecimalFormat FORMATTER = new DecimalFormat("#,###.##");

    public static String fDecimal(byte number) {
        return FORMATTER.format(number);
    }

    public static String fDecimal(short number) {
        return FORMATTER.format(number);
    }

    public static String fDecimal(int number) {
        return FORMATTER.format(number);
    }

    public static String fDecimal(long number) {
        return FORMATTER.format(number);
    }

    public static String fDecimal(float number) {
        return FORMATTER.format(number);
    }

    public static String fDecimal(double number) {
        return FORMATTER.format(number);
    }

    public static void unlockIPAdvancement(Player player, String name) {
        ServerPlayer serverPlayer;
        Level level;
        if (player instanceof ServerPlayer && (level = (serverPlayer = (ServerPlayer)player).getCommandSenderWorld()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            PlayerAdvancements advancements = serverPlayer.getAdvancements();
            ServerAdvancementManager manager = level2.getServer().getAdvancements();
            AdvancementHolder advancement = manager.get(ResourceUtils.ip(name));
            if (advancement != null) {
                advancements.award(advancement, "code_trigger");
            }
        }
    }

    public static boolean isFluidRelatedItemStack(ItemStack stack) {
        return !stack.isEmpty() && stack.getCapability(Capabilities.FluidHandler.ITEM) != null;
    }

    public static void dropItem(Level level, BlockPos pos, ItemStack stack) {
        Utils.dropItem(level, pos, stack, ItemEntity::setDefaultPickUpDelay);
    }

    public static void dropItemNoDelay(Level level, BlockPos pos, ItemStack stack) {
        Utils.dropItem(level, pos, stack, ItemEntity::setNoPickUpDelay);
    }

    public static void dropItem(Level level, BlockPos pos, ItemStack stack, Consumer<ItemEntity> func) {
        if (!(level.isClientSide || stack.isEmpty() || level.restoringBlockSnapshots)) {
            double f = (double)EntityType.ITEM.getHeight() / 2.0;
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5 - f;
            double z = (double)pos.getZ() + 0.5;
            ItemEntity entity = new ItemEntity(level, x, y, z, stack);
            func.accept(entity);
            level.addFreshEntity((Entity)entity);
        }
    }

    public static ColumnPos toColumnPos(BlockPos pos) {
        return new ColumnPos(pos.getX(), pos.getZ());
    }

    @Nullable
    public static MultiblockBlockEntityMaster<?> getMultiblockMasterBE(Level level, BlockPos pos) {
        MultiblockBlockEntityMaster master;
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof IMultiblockBE)) {
            return null;
        }
        IMultiblockBE mb = (IMultiblockBE)be;
        if (be instanceof MultiblockBlockEntityMaster) {
            MultiblockBlockEntityMaster master2 = (MultiblockBlockEntityMaster)be;
            return master2;
        }
        if (mb.getHelper().getContext() == null) {
            return null;
        }
        IMultiblockBEHelper helper = mb.getHelper();
        BlockPos masterPos = helper.getContext().getLevel().toAbsolute(helper.getMultiblock().masterPosInMB());
        be = level.getBlockEntity(masterPos);
        return be instanceof MultiblockBlockEntityMaster ? (master = (MultiblockBlockEntityMaster)be) : null;
    }

    @Nullable
    public static IMultiblockBEHelperMaster<?> getMultiblockMasterHelper(Level level, IMultiblockBEHelper<?> helper) {
        IMultiblockBEHelperMaster iMultiblockBEHelperMaster;
        if (helper instanceof IMultiblockBEHelperMaster) {
            IMultiblockBEHelperMaster masterHelper = (IMultiblockBEHelperMaster)helper;
            return masterHelper;
        }
        if (helper.getContext() == null) {
            return null;
        }
        BlockPos masterPos = helper.getContext().getLevel().toAbsolute(helper.getMultiblock().masterPosInMB());
        BlockEntity be = level.getBlockEntity(masterPos);
        if (be instanceof MultiblockBlockEntityMaster) {
            MultiblockBlockEntityMaster master = (MultiblockBlockEntityMaster)be;
            iMultiblockBEHelperMaster = master.getHelper();
        } else {
            iMultiblockBEHelperMaster = null;
        }
        return iMultiblockBEHelperMaster;
    }

    private Utils() {
    }
}

