/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartingEvent;

@EventBusSubscriber(modid="immersivepetroleum", bus=EventBusSubscriber.Bus.GAME)
public class RegistryUtils {
    private static Registry<Biome> BIOME_REGISTRY;

    @SubscribeEvent
    public static void serverStart(ServerStartingEvent event) {
        BIOME_REGISTRY = event.getServer().registryAccess().registryOrThrow(Registries.BIOME);
    }

    @Nonnull
    public static ResourceLocation getRegistryNameOf(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    @Nonnull
    public static ResourceLocation getRegistryNameOf(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    @Nonnull
    public static ResourceLocation getRegistryNameOf(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    @Nullable
    public static Fluid getFluidFromRegistryName(ResourceLocation rl) {
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)rl);
        Holder holder = BuiltInRegistries.FLUID.getHolder(resourceKey).orElse(null);
        return holder != null ? (Fluid)holder.value() : null;
    }

    public static Optional<List<Holder<Biome>>> listBiomesInTag(TagKey<Biome> tag) {
        return BIOME_REGISTRY.getTag(tag).map(holders -> holders.stream().toList());
    }

    @Nullable
    public static ResourceLocation getRegistryNameOf(SoundEvent soundEvent) {
        return BuiltInRegistries.SOUND_EVENT.getKey((Object)soundEvent);
    }

    @Nullable
    public static ResourceLocation getRegistryNameOf(MobEffect mobEffect) {
        return BuiltInRegistries.MOB_EFFECT.getKey((Object)mobEffect);
    }

    @Nonnull
    public static ResourceLocation getRegistryNameOf(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
    }

    @Nullable
    public static ResourceLocation getRegistryNameOf(BlockEntityType<?> blockEntityType) {
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(blockEntityType);
    }

    @Nullable
    public static ResourceLocation getRegistryNameOf(ParticleType<?> particleType) {
        return BuiltInRegistries.PARTICLE_TYPE.getKey(particleType);
    }

    @Nullable
    public static ResourceLocation getRegistryNameOf(RecipeType<?> recipeType) {
        return BuiltInRegistries.RECIPE_TYPE.getKey(recipeType);
    }

    @Nullable
    public static ResourceLocation getRegistryNameOf(RecipeSerializer<?> recipeSerializer) {
        return BuiltInRegistries.RECIPE_SERIALIZER.getKey(recipeSerializer);
    }

    @Nullable
    public static ResourceLocation getRegistryNameOf(MenuType<?> menuType) {
        return BuiltInRegistries.MENU.getKey(menuType);
    }

    private RegistryUtils() {
    }
}

