/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.sound;

import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.sound.IPTickableSound;
import flaxbeard.immersivepetroleum.common.sound.IPlaySound;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class IPEntitySound
extends IPTickableSound {
    protected Entity entity;

    public IPEntitySound(Entity entity, SoundEvent sound, float volume, float pitch) {
        super(sound, volume, pitch);
        this.entity = entity;
    }

    public final void tick() {
        Entity entity;
        if (this.entity.isAlive() && (entity = this.entity) instanceof IPlaySound) {
            IPlaySound soundPlayer = (IPlaySound)entity;
            this.stop = soundPlayer.stopSound(this.getLocation());
            if (!this.stop && MCUtil.getPlayer() != null) {
                float soundRadiusSqr = soundPlayer.soundRadiusSqr();
                double distancedSqr = MCUtil.getPlayer().distanceToSqr(this.entity);
                if (distancedSqr > (double)soundRadiusSqr) {
                    this.stop = true;
                }
            }
        }
        if (!this.entity.isAlive() && !this.isStopped()) {
            this.stop();
        }
    }

    @Nonnull
    public SoundSource getSource() {
        return SoundSource.NEUTRAL;
    }

    public double getX() {
        return this.entity.getX();
    }

    public double getY() {
        return this.entity.getY();
    }

    public double getZ() {
        return this.entity.getZ();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public UUID getUUID() {
        return this.entity.getUUID();
    }

    public boolean isLooping() {
        return true;
    }

    public boolean isRelative() {
        return false;
    }
}

