/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.reservoir.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import flaxbeard.immersivepetroleum.common.reservoir.util.BWList;
import flaxbeard.immersivepetroleum.common.reservoir.util.IValidator;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import malte0811.dualcodecs.DualCodec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class BWListDimension
extends BWList<ResourceKey<Level>, Validator> {
    public static final Codec<BWListDimension> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.listOf().fieldOf("list").xmap(strings -> strings.stream().map(Validator::new).collect(Collectors.toSet()), set -> set.stream().map(IValidator::getString).toList()).forGetter(BWList::getSet), (App)Codec.BOOL.fieldOf("isBlacklist").forGetter(BWList::isBlacklist)).apply((Applicative)inst, BWListDimension::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BWListDimension> CODEC_STREAM = new StreamCodec<RegistryFriendlyByteBuf, BWListDimension>(){

        @Nonnull
        public BWListDimension decode(@Nonnull RegistryFriendlyByteBuf buf) {
            int size = buf.readInt();
            HashSet<Validator> set = new HashSet<Validator>(size);
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    set.add((Validator)Validator.STREAM_CODEC.decode((Object)buf));
                }
            }
            boolean isBlacklist = buf.readBoolean();
            return new BWListDimension(set, isBlacklist);
        }

        public void encode(@Nonnull RegistryFriendlyByteBuf buf, @Nonnull BWListDimension dimensions) {
            buf.writeInt(dimensions.set.size());
            dimensions.set.forEach(v -> Validator.STREAM_CODEC.encode((Object)buf, v));
            buf.writeBoolean(dimensions.isBlacklist());
        }
    };
    public static final DualCodec<RegistryFriendlyByteBuf, BWListDimension> CODECS = new DualCodec(CODEC, CODEC_STREAM);

    public BWListDimension(boolean isBlacklist) {
        this(new HashSet<Validator>(), isBlacklist);
    }

    public BWListDimension(Set<Validator> set, boolean isBlacklist) {
        this(set, isBlacklist ? BWList.Mode.BLACKLIST : BWList.Mode.WHITELIST);
    }

    public BWListDimension(Set<Validator> set, BWList.Mode mode) {
        super(set, mode, Validator::new);
    }

    @Override
    public boolean isValid(ResourceKey<Level> dimensionKey) {
        return this.isValid((V validator) -> validator.test(dimensionKey));
    }

    public static class Validator
    implements IValidator {
        public static final StreamCodec<ByteBuf, Validator> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(Validator::new, Validator::location);
        private final ResourceLocation location;

        public Validator(String rlString) {
            this(ResourceLocation.parse((String)rlString));
        }

        public Validator(ResourceLocation location) {
            this.location = location;
        }

        @Override
        public ResourceLocation location() {
            return this.location;
        }

        public String toString() {
            return this.getString();
        }
    }
}

