/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.reservoir.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import flaxbeard.immersivepetroleum.common.reservoir.util.BWList;
import flaxbeard.immersivepetroleum.common.reservoir.util.IValidator;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import malte0811.dualcodecs.DualCodec;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class BWListBiome
extends BWList<Holder<Biome>, Validator> {
    public static final Codec<BWListBiome> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.listOf().fieldOf("list").xmap(strings -> strings.stream().map(Validator::new).collect(Collectors.toSet()), set -> set.stream().map(Validator::getString).toList()).forGetter(BWList::getSet), (App)Codec.BOOL.fieldOf("isBlacklist").forGetter(BWList::isBlacklist)).apply((Applicative)inst, BWListBiome::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BWListBiome> CODEC_STREAM = new StreamCodec<RegistryFriendlyByteBuf, BWListBiome>(){

        @Nonnull
        public BWListBiome decode(@Nonnull RegistryFriendlyByteBuf buf) {
            int size = buf.readInt();
            HashSet<Validator> set = new HashSet<Validator>(size);
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    set.add((Validator)Validator.STREAM_CODEC.decode((Object)buf));
                }
            }
            boolean isBlacklist = buf.readBoolean();
            return new BWListBiome(set, isBlacklist);
        }

        public void encode(@Nonnull RegistryFriendlyByteBuf buf, @Nonnull BWListBiome biomes) {
            buf.writeInt(biomes.set.size());
            biomes.set.forEach(v -> Validator.STREAM_CODEC.encode((Object)buf, v));
            buf.writeBoolean(biomes.isBlacklist());
        }
    };
    public static final DualCodec<RegistryFriendlyByteBuf, BWListBiome> CODECS = new DualCodec(CODEC, CODEC_STREAM);

    public BWListBiome(boolean isBlacklist) {
        this(new HashSet<Validator>(), isBlacklist);
    }

    public BWListBiome(Set<Validator> set, boolean isBlacklist) {
        this(set, isBlacklist ? BWList.Mode.BLACKLIST : BWList.Mode.WHITELIST);
    }

    public BWListBiome(Set<Validator> set, BWList.Mode mode) {
        super(set, mode, Validator::new);
    }

    @Override
    public boolean isValid(Holder<Biome> biomeHolder) {
        return this.isValid((V validator) -> validator.test(biomeHolder));
    }

    public static class Validator
    implements IValidator {
        public static final StreamCodec<ByteBuf, Validator> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(Validator::new, Validator::getString);
        private final ResourceLocation location;
        private TagKey<Biome> biomeTag = null;

        protected Validator(String rlString) {
            boolean isTag = rlString.startsWith("#");
            if (isTag) {
                rlString = rlString.substring(1);
            }
            ResourceLocation location = ResourceLocation.parse((String)rlString);
            if (isTag) {
                this.biomeTag = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)location);
            }
            this.location = location;
        }

        public Validator(ResourceLocation location) {
            this.location = location;
        }

        @Override
        public ResourceLocation location() {
            return this.location;
        }

        public boolean test(Holder<Biome> holder) {
            return this.biomeTag != null && holder.is(this.biomeTag) || this.test(holder.getKey());
        }

        public boolean isTag() {
            return this.biomeTag != null;
        }

        public TagKey<Biome> getTag() {
            return this.biomeTag;
        }

        @Override
        public String getString() {
            Object str = this.location.toString();
            if (this.isTag()) {
                str = "#" + (String)str;
            }
            return str;
        }

        public String toString() {
            return this.getString();
        }
    }
}

