/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.reservoir.util;

import flaxbeard.immersivepetroleum.common.reservoir.util.IValidator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public abstract class BWList<T, V extends IValidator> {
    protected final Set<V> set;
    protected final Mode mode;
    private final Function<String, V> constructor;

    protected BWList(Set<V> set, Mode mode, Function<String, V> validatorConstructor) {
        this.set = set;
        this.mode = mode;
        this.constructor = validatorConstructor;
    }

    public boolean hasEntries() {
        return !this.set.isEmpty();
    }

    public abstract boolean isValid(T var1);

    protected final boolean isValid(Predicate<V> predicate) {
        if (this.set.isEmpty()) {
            return true;
        }
        boolean matchFound = this.set.stream().anyMatch(predicate);
        return this.isBlacklist() != matchFound;
    }

    public boolean isBlacklist() {
        return this.mode == Mode.BLACKLIST;
    }

    protected Set<V> getSet() {
        return this.set;
    }

    public void forEach(Consumer<V> action) {
        this.set.forEach(action);
    }

    public void readFromNbt(CompoundTag nbt) {
        ListTag list;
        if (nbt.contains("list", 9) && !(list = nbt.getList("list", 8)).isEmpty()) {
            this.set.clear();
            list.forEach(t -> {
                if (t instanceof StringTag) {
                    StringTag strTag = (StringTag)t;
                    this.set.add((IValidator)this.constructor.apply(strTag.getAsString()));
                }
            });
        }
    }

    public CompoundTag writeToNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("isBlacklist", this.isBlacklist());
        if (this.hasEntries()) {
            ListTag nbtList = new ListTag();
            this.set.forEach(IValidator::getString);
            nbt.put("list", (Tag)nbtList);
        }
        return nbt;
    }

    public static enum Mode {
        BLACKLIST,
        WHITELIST;

    }
}

