/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPDataComponents;
import flaxbeard.immersivepetroleum.common.items.DebugItem;
import flaxbeard.immersivepetroleum.common.network.INetMessage;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageDebugSync
implements INetMessage {
    public static final CustomPacketPayload.Type<MessageDebugSync> ID = INetMessage.createType("debug_sync");
    public static final StreamCodec<ByteBuf, MessageDebugSync> CODEC = ByteBufCodecs.INT.map(MessageDebugSync::new, msg -> msg.mode.id());
    private final DebugItem.Mode mode;

    public MessageDebugSync(DebugItem.Mode mode) {
        this.mode = mode;
    }

    private MessageDebugSync(int id) {
        this.mode = DebugItem.Mode.fromId(id);
    }

    @Nonnull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.connection().getDirection().getReceptionSide() == LogicalSide.SERVER) {
                boolean off;
                Player player = context.player();
                ItemStack mainItem = player.getMainHandItem();
                ItemStack secondItem = player.getOffhandItem();
                boolean main = !mainItem.isEmpty() && mainItem.getItem() == IPContent.DEBUGITEM.get();
                boolean bl = off = !secondItem.isEmpty() && secondItem.getItem() == IPContent.DEBUGITEM.get();
                if (main || off) {
                    ItemStack target = main ? mainItem : secondItem;
                    target.set(IPDataComponents.DEBUG_ITEM, (Object)this.mode);
                }
            }
        });
    }
}

