/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.network.INetMessage;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageConsumeBoatFuel
implements INetMessage {
    public static final CustomPacketPayload.Type<MessageConsumeBoatFuel> ID = INetMessage.createType("consume_speedboat_fuel");
    public static final StreamCodec<ByteBuf, MessageConsumeBoatFuel> CODEC = ByteBufCodecs.INT.map(MessageConsumeBoatFuel::new, message -> message.amount);
    private final int amount;

    public MessageConsumeBoatFuel(int amount) {
        this.amount = amount;
    }

    @Nonnull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    @Override
    public void process(IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity;
            if (context.connection().getDirection().getReceptionSide() == LogicalSide.SERVER && (entity = context.player().getVehicle()) instanceof MotorboatEntity) {
                MotorboatEntity boat = (MotorboatEntity)entity;
                FluidStack fluid = boat.getTank().getFluid();
                if (fluid != FluidStack.EMPTY) {
                    fluid.setAmount(Math.max(0, fluid.getAmount() - this.amount));
                }
                boat.setContainedFluid(fluid);
            }
        });
    }
}

