/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.common.network.MessageConsumeBoatFuel;
import flaxbeard.immersivepetroleum.common.network.MessageDebugSync;
import flaxbeard.immersivepetroleum.common.network.MessageDerrick;
import flaxbeard.immersivepetroleum.common.network.MessageProjectorSync;
import flaxbeard.immersivepetroleum.common.network.MessageSurveyResultDetails;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class IPPacketHandler {
    public static void init(PayloadRegistrar registrar) {
        registrar.commonToServer(MessageConsumeBoatFuel.ID, MessageConsumeBoatFuel.CODEC, MessageConsumeBoatFuel::process);
        registrar.commonToServer(MessageDebugSync.ID, MessageDebugSync.CODEC, MessageDebugSync::process);
        registrar.commonToServer(MessageProjectorSync.ID, MessageProjectorSync.CODEC, MessageProjectorSync::process);
        registrar.commonToServer(MessageDerrick.ID, MessageDerrick.CODEC, MessageDerrick::process);
        registrar.commonToServer(MessageSurveyResultDetails.ClientToServer.ID, MessageSurveyResultDetails.ClientToServer.CODEC, MessageSurveyResultDetails.ClientToServer::process);
        registrar.commonToClient(MessageSurveyResultDetails.ServerToClient.ID, MessageSurveyResultDetails.ServerToClient.CODEC, MessageSurveyResultDetails.ServerToClient::process);
    }

    public static <MSG extends CustomPacketPayload> void sendToPlayer(Player player, MSG message) {
        if (message == null || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <MSG extends CustomPacketPayload> void sendToServer(MSG message) {
        if (message == null) {
            return;
        }
        PacketDistributor.sendToServer(message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <MSG extends CustomPacketPayload> void sendToDimension(Level level, MSG message) {
        if (message == null || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <MSG extends CustomPacketPayload> void sendAll(MSG message) {
        if (message == null) {
            return;
        }
        PacketDistributor.sendToAllPlayers(message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

