/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirBoundingBox;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirPolygon;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.IPModels;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPDataComponents;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.network.MessageDebugSync;
import flaxbeard.immersivepetroleum.common.reservoir.util.BWListBiome;
import flaxbeard.immersivepetroleum.common.reservoir.util.BWListDimension;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.fluids.FluidStack;

public class DebugItem
extends IPItemBase {
    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        return Component.literal((String)"IP Debugging Tool").withStyle(ChatFormatting.LIGHT_PURPLE);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext ctx, List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)"[Shift + Scroll-UP/DOWN] Change mode.").withStyle(ChatFormatting.GRAY));
        Mode mode = DebugItem.getMode(stack);
        if (mode == Mode.DISABLED) {
            tooltip.add((Component)Component.literal((String)"  Disabled.").withStyle(ChatFormatting.DARK_GRAY));
        } else {
            tooltip.add((Component)Component.literal((String)("  " + mode.display)).withStyle(ChatFormatting.DARK_GRAY));
        }
        tooltip.add((Component)Component.literal((String)"You're not supposed to have this.").withStyle(ChatFormatting.DARK_RED));
        super.appendHoverText(stack, ctx, tooltip, flag);
    }

    @Override
    public boolean addSelfToCreativeTab() {
        return false;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand handIn) {
        if (!worldIn.isClientSide) {
            Mode mode = DebugItem.getMode(playerIn.getItemInHand(handIn));
            switch (mode.ordinal()) {
                case 6: {
                    try {
                        BlockPos playerPos = playerIn.blockPosition();
                        int x = playerPos.getX();
                        int z = playerPos.getZ();
                        if (ReservoirHandler.getValueOf(worldIn, x, z) > -1.0) {
                            long t = System.nanoTime();
                            ReservoirPolygon reservoirPolygon = ReservoirPolygon.make(worldIn, new ColumnPos(x, z));
                            t = System.nanoTime() - t;
                            ImmersivePetroleum.log.info("Took: {}ns ({}ms)", (Object)t, (Object)Float.valueOf((float)t / 1000000.0f));
                            Reservoir reservoir = ReservoirHandler.getReservoir(worldIn, playerPos);
                            if (reservoir != null) {
                                int i;
                                List<ColumnPos> newPolygon = reservoirPolygon.getPolygonList();
                                List<ColumnPos> ogPolygon = reservoir.getPolygon().getPolygonList();
                                ImmersivePetroleum.log.info("{} - {} {}", (Object)newPolygon.size(), (Object)ogPolygon.size(), (Object)(newPolygon.size() == ogPolygon.size() ? "Equal" : "Not Equal"));
                                BlockState air = Blocks.AIR.defaultBlockState();
                                BlockState blackWool = Blocks.BLACK_WOOL.defaultBlockState();
                                BlockState whiteWool = Blocks.WHITE_WOOL.defaultBlockState();
                                BlockState greenWool = Blocks.GREEN_WOOL.defaultBlockState();
                                BlockState limeWool = Blocks.LIME_WOOL.defaultBlockState();
                                BlockState yellowWool = Blocks.YELLOW_WOOL.defaultBlockState();
                                BlockState redWool = Blocks.RED_WOOL.defaultBlockState();
                                BlockPos defaultHeight = new BlockPos(0, 127, 0);
                                int range = 3;
                                ReservoirBoundingBox bb = reservoir.getBoundingBox();
                                for (int k = bb.zMin() - 3; k <= bb.zMax() + 3; ++k) {
                                    for (int i2 = bb.xMin() - 3; i2 <= bb.xMax() + 3; ++i2) {
                                        for (int j = -3; j <= 3; ++j) {
                                            BlockPos bPos = defaultHeight.offset(i2, j, k);
                                            worldIn.setBlockAndUpdate(bPos, air);
                                        }
                                        if (reservoir.getPolygon().contains(i2, k)) {
                                            worldIn.setBlockAndUpdate(defaultHeight.offset(i2, -3, k), limeWool);
                                            continue;
                                        }
                                        worldIn.setBlockAndUpdate(defaultHeight.offset(i2, -3, k), redWool);
                                    }
                                }
                                for (i = 0; i < ogPolygon.size(); ++i) {
                                    ColumnPos cPos = ogPolygon.get(i);
                                    BlockPos bPos = defaultHeight.offset(cPos.x(), 0, cPos.z());
                                    worldIn.setBlockAndUpdate(bPos, blackWool);
                                }
                                for (i = 0; i < newPolygon.size(); ++i) {
                                    ColumnPos cPos = newPolygon.get(i);
                                    BlockPos bPos = defaultHeight.offset(cPos.x(), 1, cPos.z());
                                    BlockState state = whiteWool;
                                    if (i == 0) {
                                        state = greenWool;
                                    }
                                    if (i == newPolygon.size() / 2) {
                                        state = yellowWool;
                                    }
                                    if (i == newPolygon.size() - 1) {
                                        state = redWool;
                                    }
                                    worldIn.setBlockAndUpdate(bPos, state);
                                }
                            }
                        }
                    }
                    catch (Exception t) {
                        t.printStackTrace(System.err);
                    }
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
                }
                case 4: {
                    try {
                        IPModels.getModels().forEach(IPModel::init);
                        playerIn.displayClientMessage((Component)Component.literal((String)"Models refreshed."), true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
                }
                case 2: {
                    BlockPos playerPos = playerIn.blockPosition();
                    ChunkPos cPos = new ChunkPos(playerPos);
                    int chunkX = cPos.getMinBlockX();
                    int chunkZ = cPos.getMinBlockZ();
                    int x = playerPos.getX() - cPos.getMinBlockX();
                    int z = playerPos.getZ() - cPos.getMinBlockZ();
                    double noise = ReservoirHandler.getValueOf(worldIn, chunkX + x, chunkZ + z);
                    playerIn.displayClientMessage((Component)Component.literal((String)(chunkX + " " + chunkZ + ": " + noise)), true);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
                }
                case 3: {
                    BlockPos playerPos = playerIn.blockPosition();
                    Reservoir reservoir = ReservoirHandler.getReservoir(worldIn, playerPos);
                    if (reservoir != null) {
                        int x = playerPos.getX();
                        int z = playerPos.getZ();
                        float pressure = reservoir.getPressure(worldIn, x, z);
                        if (playerIn.isShiftKeyDown()) {
                            reservoir.setAmount(reservoir.getCapacity());
                            reservoir.setDirty();
                            playerIn.displayClientMessage((Component)Component.literal((String)"Reservoir Refilled."), true);
                            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
                        }
                        String out = String.format(Locale.ENGLISH, "Noise: %.3f, Amount: %d/%d, Pressure: %.3f, Flow: %d, Type: %s", ReservoirHandler.getValueOf(worldIn, x, z), reservoir.getAmount(), reservoir.getCapacity(), Float.valueOf(pressure), Reservoir.getFlow(pressure), new FluidStack(reservoir.getFluid(), 1).getHoverName().getString());
                        playerIn.displayClientMessage((Component)Component.literal((String)out), true);
                    }
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
                }
                case 5: {
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
                }
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.getItemInHand(handIn));
        }
        return super.use(worldIn, playerIn, handIn);
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack held = player.getItemInHand(context.getHand());
        Mode mode = DebugItem.getMode(held);
        BlockEntity te = context.getLevel().getBlockEntity(context.getClickedPos());
        switch (mode.ordinal()) {
            case 6: {
                Level world = context.getLevel();
                if (!world.isClientSide) {
                    BlockPos pos = context.getClickedPos();
                    ResourceKey dimension = world.dimension();
                    Holder biome = world.getBiome(pos);
                    player.displayClientMessage((Component)Component.literal((String)dimension.location().toString()), false);
                    for (RecipeHolder<ReservoirType> holder : ReservoirType.map.values()) {
                        ReservoirType res = (ReservoirType)holder.value();
                        BWListDimension dims = res.getDimensions();
                        BWListBiome biom = res.getBiomes();
                        boolean validDimension = dims.isValid((ResourceKey<Level>)dimension);
                        boolean validBiome = biom.isValid((Holder<Biome>)biome);
                        MutableComponent component = Component.literal((String)res.name).append((Component)Component.literal((String)" Dimension").withStyle(validDimension ? ChatFormatting.GREEN : ChatFormatting.RED)).append((Component)Component.literal((String)" Biome").withStyle(validBiome ? ChatFormatting.GREEN : ChatFormatting.RED));
                        if (validDimension && validBiome) {
                            component = component.append(" (can spawn here)");
                        }
                        player.displayClientMessage((Component)component, false);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void onSpeedboatClick(MotorboatEntity speedboatEntity, Player player, ItemStack debugStack) {
        if (speedboatEntity.level().isClientSide || DebugItem.getMode(debugStack) != Mode.INFO_SPEEDBOAT) {
            return;
        }
        MutableComponent textOut = Component.literal((String)"-- Speedboat --\n");
        FluidStack fluid = speedboatEntity.getTank().getFluid();
        if (fluid == FluidStack.EMPTY) {
            textOut.append("Tank: Empty");
        } else {
            textOut.append("Tank: " + fluid.getAmount() + "/" + speedboatEntity.getMaxFuel() + "mB of ").append(fluid.getHoverName());
        }
        MutableComponent upgradesText = Component.literal((String)"\n");
        NonNullList<ItemStack> upgrades = speedboatEntity.getUpgrades();
        int i = 0;
        for (ItemStack upgrade : upgrades) {
            if (upgrade == null || upgrade == ItemStack.EMPTY) {
                upgradesText.append("Upgrade " + ++i + ": Empty\n");
                continue;
            }
            upgradesText.append("Upgrade " + ++i + ": ").append(upgrade.getHoverName()).append("\n");
        }
        textOut.append((Component)upgradesText);
        player.sendSystemMessage((Component)textOut);
    }

    public static void setModeClient(ItemStack stack, Mode mode) {
        stack.set(IPDataComponents.DEBUG_ITEM, (Object)mode);
        IPPacketHandler.sendToServer(new MessageDebugSync(mode));
    }

    public static Mode getMode(ItemStack stack) {
        return Mode.fromStack(stack);
    }

    public static enum Mode {
        DISABLED("Disabled"),
        INFO_SPEEDBOAT("Info: Speedboat"),
        SEEDBASED_RESERVOIR("Seed-Based Reservoir: Heatmap"),
        SEEDBASED_RESERVOIR_AREA_TEST("Seed-Based Reservoir Testing"),
        REFRESH_ALL_IPMODELS("Refresh all IPModels"),
        DATA_STORAGE_TESTING("Data Storage Tests"),
        GENERAL_TEST("This one could be dangerous to trigger!");

        public static final Codec<Mode> CODEC;
        public static final StreamCodec<ByteBuf, Mode> CODEC_STREAM;
        public final String display;

        private Mode(String display) {
            this.display = display;
        }

        public int id() {
            return this.ordinal();
        }

        public static Mode fromId(int id) {
            if (id < 0 || id >= Mode.values().length) {
                return DISABLED;
            }
            return Mode.values()[id];
        }

        public static Mode fromStack(ItemStack stack) {
            Mode mode = (Mode)((Object)stack.get(IPDataComponents.DEBUG_ITEM));
            return mode == null ? DISABLED : mode;
        }

        static {
            CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("mode").forGetter(Mode::id)).apply((Applicative)inst, Mode::fromId));
            CODEC_STREAM = ByteBufCodecs.INT.map(Mode::fromId, Mode::id);
        }
    }

    public static class ClientInputHandler {
        public static void onSneakScrolling(InputEvent.MouseScrollingEvent event, Player player, double scrollDelta) {
            boolean off;
            ItemStack mainItem = player.getMainHandItem();
            ItemStack secondItem = player.getOffhandItem();
            boolean main = !mainItem.isEmpty() && mainItem.getItem() == IPContent.DEBUGITEM.get();
            boolean bl = off = !secondItem.isEmpty() && secondItem.getItem() == IPContent.DEBUGITEM.get();
            if (main || off) {
                ItemStack target = main ? mainItem : secondItem;
                Mode mode = DebugItem.getMode(target);
                int id = mode.ordinal() + (int)scrollDelta;
                if (id < 0) {
                    id = Mode.values().length - 1;
                }
                if (id >= Mode.values().length) {
                    id = 0;
                }
                mode = Mode.values()[id];
                DebugItem.setModeClient(target, mode);
                player.displayClientMessage((Component)Component.literal((String)mode.display), true);
                event.setCanceled(true);
            }
        }
    }
}

