/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.gui;

import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class IPSlot
extends SlotItemHandler {
    private final Predicate<ItemStack> consumer;

    public IPSlot(IItemHandler inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
        this.consumer = null;
    }

    public IPSlot(IItemHandler inventoryIn, int index, int xPosition, int yPosition, Predicate<ItemStack> placeCheck) {
        super(inventoryIn, index, xPosition, yPosition);
        this.consumer = placeCheck;
    }

    public boolean mayPlace(@Nonnull ItemStack stack) {
        if (this.consumer != null) {
            return this.consumer.test(stack);
        }
        return super.mayPlace(stack);
    }

    public static class FluidContainer
    extends IPSlot {
        FluidFilter filter;

        public FluidContainer(IItemHandler inv, int id, int x, int y, FluidFilter filter) {
            super(inv, id, x, y);
            this.filter = filter;
        }

        @Override
        public boolean mayPlace(@Nonnull ItemStack stack) {
            IFluidHandlerItem capability = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            if (capability != null && capability.getTanks() > 0) {
                return switch (this.filter.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 2 -> {
                        if (!capability.getFluidInTank(0).isEmpty()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> capability.getFluidInTank(0).isEmpty();
                    case 0 -> true;
                };
            }
            return false;
        }

        public static enum FluidFilter {
            ANY,
            EMPTY,
            FULL;

        }
    }

    public static class CokerInput
    extends IPSlot {
        public CokerInput(IItemHandler inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        @Override
        public boolean mayPlace(@Nonnull ItemStack stack) {
            return !stack.isEmpty() && CokerUnitRecipe.hasRecipeWithInput(stack, true);
        }
    }

    public static class ItemOutput
    extends IPSlot {
        public ItemOutput(IItemHandler inventoryIn, int id, int x, int y) {
            super(inventoryIn, id, x, y);
        }

        @Override
        public boolean mayPlace(@Nonnull ItemStack stack) {
            return false;
        }
    }
}

