/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.gui;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.HydroTreaterMultiblock;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.hydro_treater.HydroTreaterLogic;
import flaxbeard.immersivepetroleum.common.gui.MultiblockAwareGuiContainer;
import flaxbeard.immersivepetroleum.common.util.inventory.FluidTankFiltered;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class HydrotreaterContainer
extends MultiblockAwareGuiContainer {
    public final FluidTankFiltered primary;
    public final FluidTankFiltered secondary;
    public final FluidTankFiltered output;
    public final IEnergyStorage energy;

    public static HydrotreaterContainer makeServer(MenuType<?> type, int id, Inventory player, IEContainerMenu.MultiblockMenuContext<HydroTreaterLogic.State> ctx) {
        HydroTreaterLogic.State state = (HydroTreaterLogic.State)ctx.mbContext().getState();
        HydroTreaterLogic.Tanks tanks = state.tanks;
        AveragingEnergyStorage energy = state.getEnergy();
        return new HydrotreaterContainer(HydrotreaterContainer.multiblockCtx(type, (int)id, ctx), tanks, energy);
    }

    public static HydrotreaterContainer makeClient(MenuType<?> type, int id, Inventory player) {
        HydroTreaterLogic.Tanks tanks = HydroTreaterLogic.Tanks.client();
        AveragingEnergyStorage energy = new AveragingEnergyStorage(8000);
        return new HydrotreaterContainer(HydrotreaterContainer.clientCtx(type, (int)id), tanks, energy);
    }

    private HydrotreaterContainer(IEContainerMenu.MenuContext ctx, HydroTreaterLogic.Tanks tanks, AveragingEnergyStorage energy) {
        super(ctx, HydroTreaterMultiblock.INSTANCE);
        this.primary = tanks.primary();
        this.secondary = tanks.secondary();
        this.output = tanks.output();
        this.energy = energy;
        this.addGenericData(this.primary.getContainerData());
        this.addGenericData(this.secondary.getContainerData());
        this.addGenericData(this.output.getContainerData());
        this.addGenericData(GenericContainerData.energy((IMutableEnergyStorage)energy));
    }
}

