/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.gui;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import flaxbeard.immersivepetroleum.api.crafting.DistillationTowerRecipe;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.DistillationTowerMultiblock;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.distillation_tower.DistillationTowerLogic;
import flaxbeard.immersivepetroleum.common.gui.IPSlot;
import flaxbeard.immersivepetroleum.common.gui.MultiblockAwareGuiContainer;
import flaxbeard.immersivepetroleum.common.util.inventory.FluidTankFiltered;
import flaxbeard.immersivepetroleum.common.util.inventory.MultiFluidTankFiltered;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class DistillationTowerContainer
extends MultiblockAwareGuiContainer {
    public final ItemStackHandler handler;
    public final IEnergyStorage energy;
    public final FluidTankFiltered input;
    public final MultiFluidTankFiltered output;

    public static DistillationTowerContainer makeServer(MenuType<?> type, int id, Inventory player, IEContainerMenu.MultiblockMenuContext<DistillationTowerLogic.State> ctx) {
        DistillationTowerLogic.State state = (DistillationTowerLogic.State)ctx.mbContext().getState();
        DistillationTowerLogic.Tanks tanks = state.tanks;
        AveragingEnergyStorage energy = state.getEnergy();
        return new DistillationTowerContainer(DistillationTowerContainer.multiblockCtx(type, (int)id, ctx), player, new ItemStackHandler(state.inventory.getInternal()), tanks, energy);
    }

    public static DistillationTowerContainer makeClient(MenuType<?> type, int id, Inventory player) {
        DistillationTowerLogic.Tanks tanks = DistillationTowerLogic.Tanks.client();
        AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        return new DistillationTowerContainer(DistillationTowerContainer.clientCtx(type, (int)id), player, new ItemStackHandler(DistillationTowerLogic.Inventory.size()), tanks, energy);
    }

    private DistillationTowerContainer(IEContainerMenu.MenuContext ctx, Inventory playerInventory, ItemStackHandler handler, DistillationTowerLogic.Tanks tanks, AveragingEnergyStorage energy) {
        super(ctx, DistillationTowerMultiblock.INSTANCE);
        this.handler = handler;
        this.energy = energy;
        this.input = tanks.input();
        this.output = tanks.output();
        this.addSlot((Slot)new IPSlot((IItemHandler)handler, DistillationTowerLogic.Inventory.INPUT_FILLED.id(), 12, 17, stack -> FluidUtil.getFluidHandler((ItemStack)stack).map(h -> {
            if (h.getTanks() <= 0) {
                return false;
            }
            FluidStack fs = h.getFluidInTank(0);
            if (fs.isEmpty() || this.input.getFluidAmount() > 0 && !fs.is(this.input.getFluid().getFluid())) {
                return false;
            }
            RecipeHolder<DistillationTowerRecipe> recipe = DistillationTowerRecipe.findRecipe(fs);
            return recipe != null;
        }).orElse(false)));
        this.addSlot((Slot)new IPSlot.ItemOutput((IItemHandler)handler, DistillationTowerLogic.Inventory.INPUT_EMPTY.id(), 12, 53));
        this.addSlot((Slot)new IPSlot.FluidContainer((IItemHandler)handler, DistillationTowerLogic.Inventory.OUTPUT_EMPTY.id(), 134, 17, IPSlot.FluidContainer.FluidFilter.EMPTY));
        this.addSlot((Slot)new IPSlot.ItemOutput((IItemHandler)handler, DistillationTowerLogic.Inventory.OUTPUT_FILLED.id(), 134, 53));
        this.ownSlotCount = 4;
        this.addPlayerInventorySlots(playerInventory, 8, 85);
        this.addPlayerHotbarSlots(playerInventory, 8, 143);
        this.addGenericData(this.input.getContainerData());
        this.addGenericData(this.output.getContainerData());
        this.addGenericData(GenericContainerData.energy((IMutableEnergyStorage)energy));
    }
}

