/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.fluids;

import flaxbeard.immersivepetroleum.common.CommonEventHandler;
import flaxbeard.immersivepetroleum.common.fluids.IPFluid;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class NapalmFluid
extends IPFluid {
    public NapalmFluid(IPFluid.IPFluidEntry entry) {
        super(entry);
    }

    @Override
    public int getTickDelay(@Nonnull LevelReader p_205569_1_) {
        return 10;
    }

    @Override
    public boolean hasCustomSlowdown() {
        return true;
    }

    @Override
    public double getEntitySlowdown() {
        return 0.7;
    }

    public static void processFire(IPFluid.IPFluidEntry entry, Level world, BlockPos pos) {
        ResourceLocation d = world.dimension().location();
        List list = CommonEventHandler.napalmPositions.computeIfAbsent(d, f -> new ArrayList());
        list.add(pos);
        world.setBlock(pos, Blocks.FIRE.defaultBlockState(), 3);
        for (Direction facing : Direction.values()) {
            BlockPos notifyPos = pos.relative(facing);
            if (!world.getBlockState(notifyPos).is((Block)entry.block().get())) continue;
            list.add(notifyPos);
        }
    }

    public static class NapalmFluidBlock
    extends IPFluid.IPFluidBlock {
        public NapalmFluidBlock(IPFluid.IPFluidEntry entry, BlockBehaviour.Properties props) {
            super(entry, props);
        }

        public void onPlace(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
            for (Direction facing : Direction.values()) {
                BlockPos notifyPos = pos.relative(facing);
                if (!(world.getBlockState(notifyPos).getBlock() instanceof FireBlock) && !world.getBlockState(notifyPos).is(BlockTags.FIRE)) continue;
                world.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                break;
            }
            super.onPlace(state, world, pos, oldState, isMoving);
        }

        public void neighborChanged(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
            ResourceLocation d;
            if (!(!(world.getBlockState(fromPos).getBlock() instanceof FireBlock) && !world.getBlockState(fromPos).is(BlockTags.FIRE) || CommonEventHandler.napalmPositions.containsKey(d = world.dimension().location()) && CommonEventHandler.napalmPositions.get(d).contains(fromPos))) {
                NapalmFluid.processFire(this.entry, world, pos);
            }
            super.neighborChanged(state, world, pos, blockIn, fromPos, isMoving);
        }
    }
}

