/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.fluids;

import com.google.common.collect.ImmutableList;
import flaxbeard.immersivepetroleum.common.IPCreativeTab;
import flaxbeard.immersivepetroleum.common.IPRegisters;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class IPFluid
extends FlowingFluid {
    public static final List<IPFluidEntry> FLUIDS = new ArrayList<IPFluidEntry>();
    private static IPFluidEntry staticEntry;
    protected final IPFluidEntry entry;

    public static IPFluidEntry makeFluid(String name, int density, int viscosity) {
        return IPFluid.makeFluid(name, density, viscosity, 0.014);
    }

    public static <B extends IPFluidBlock> IPFluidEntry makeFluid(String name, int density, int viscosity, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> blockFactory) {
        return IPFluid.makeFluid(name, density, viscosity, 0.014, blockFactory);
    }

    public static <S extends IPFluid> IPFluidEntry makeFluid(String name, int density, int viscosity, Function<IPFluidEntry, S> sourceFactory) {
        return IPFluid.makeFluid(name, density, viscosity, 0.014, sourceFactory);
    }

    public static <S extends IPFluid, B extends IPFluidBlock> IPFluidEntry makeFluid(String name, int density, int viscosity, Function<IPFluidEntry, S> sourceFactory, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> blockFactory) {
        return IPFluid.makeFluid(name, density, viscosity, 0.014, sourceFactory, blockFactory);
    }

    public static IPFluidEntry makeFluid(String name, int density, int viscosity, double motionScale) {
        IPFluidEntry entry = IPFluidEntry.make(name, IPFluid::new, Flowing::new, IPFluidBlock::new, IPFluid.builder(density, viscosity, motionScale));
        return entry;
    }

    public static <B extends IPFluidBlock> IPFluidEntry makeFluid(String name, int density, int viscosity, double motionScale, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> blockFactory) {
        IPFluidEntry entry = IPFluidEntry.make(name, IPFluid::new, Flowing::new, blockFactory, IPFluid.builder(density, viscosity, motionScale));
        return entry;
    }

    public static <S extends IPFluid> IPFluidEntry makeFluid(String name, int density, int viscosity, double motionScale, Function<IPFluidEntry, S> sourceFactory) {
        IPFluidEntry entry = IPFluidEntry.make(name, sourceFactory, Flowing::new, IPFluidBlock::new, IPFluid.builder(density, viscosity, motionScale));
        return entry;
    }

    public static <S extends IPFluid, B extends IPFluidBlock> IPFluidEntry makeFluid(String name, int density, int viscosity, double motionScale, Function<IPFluidEntry, S> sourceFactory, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> blockFactory) {
        IPFluidEntry entry = IPFluidEntry.make(name, sourceFactory, Flowing::new, blockFactory, IPFluid.builder(density, viscosity, motionScale));
        return entry;
    }

    private static IPFluid makeFluid(Function<IPFluidEntry, ? extends IPFluid> make, IPFluidEntry entry) {
        staticEntry = entry;
        IPFluid ret = make.apply(entry);
        staticEntry = null;
        return ret;
    }

    protected IPFluid(IPFluidEntry entry) {
        this.entry = entry;
    }

    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
        super.createFluidStateDefinition(builder);
        for (Property<?> p : (this.entry == null ? staticEntry : this.entry).properties()) {
            builder.add(new Property[]{p});
        }
    }

    protected void beforeDestroyingBlock(@Nonnull LevelAccessor arg0, @Nonnull BlockPos arg1, @Nonnull BlockState arg2) {
    }

    public boolean canConvertToSource(FluidState state, Level level, BlockPos pos) {
        return false;
    }

    protected boolean canConvertToSource(Level pLevel) {
        return false;
    }

    public boolean hasCustomSlowdown() {
        return false;
    }

    public double getEntitySlowdown() {
        return 0.8;
    }

    @Nonnull
    public Fluid getFlowing() {
        return (Fluid)this.entry.flowing.get();
    }

    @Nonnull
    public Fluid getSource() {
        return (Fluid)this.entry.source.get();
    }

    @Nonnull
    public Item getBucket() {
        return (Item)this.entry.bucket.get();
    }

    public FluidType getFluidType() {
        return (FluidType)this.entry.type.get();
    }

    protected int getDropOff(@Nonnull LevelReader arg0) {
        return 1;
    }

    protected int getSlopeFindDistance(@Nonnull LevelReader arg0) {
        return 4;
    }

    protected boolean canBeReplacedWith(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !this.isSame(fluid);
    }

    public int getTickDelay(@Nonnull LevelReader p_205569_1_) {
        return 5;
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    @Nonnull
    protected BlockState createLegacyBlock(@Nonnull FluidState state) {
        return (BlockState)((IPFluidBlock)((Object)this.entry.block.get())).defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(IPFluid.getLegacyLevel((FluidState)state)));
    }

    public boolean isSource(FluidState state) {
        return state.is(this.getSource());
    }

    public int getAmount(@Nonnull FluidState state) {
        return this.isSource(state) ? 8 : (Integer)state.getValue((Property)LEVEL);
    }

    public boolean isSame(Fluid fluidIn) {
        return fluidIn == this.getSource() || fluidIn == this.getFlowing();
    }

    private static Consumer<FluidType.Properties> builder(int density, int viscosity, double motionScale) {
        return builder -> builder.viscosity(viscosity).density(density).motionScale(motionScale);
    }

    public record IPFluidEntry(DeferredHolder<Fluid, IPFluid> source, DeferredHolder<Fluid, IPFluid> flowing, DeferredHolder<Block, IPFluidBlock> block, DeferredHolder<Item, IPBucketItem> bucket, DeferredHolder<FluidType, CustomFluidType> type, List<Property<?>> properties) {
        public Fluid get() {
            return (Fluid)this.source().get();
        }

        public void setEffect(Holder<MobEffect> effect, int duration, int level) {
            ((IPFluidBlock)((Object)this.block().get())).setEffect(effect, duration, level);
        }

        protected static <S extends IPFluid, F extends IPFluid, B extends IPFluidBlock> IPFluidEntry make(String name, Function<IPFluidEntry, S> makeSource, Function<IPFluidEntry, F> makeFlowing, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> makeBlock, @javax.annotation.Nullable Consumer<FluidType.Properties> buildAttributes) {
            return IPFluidEntry.make(name, 0, makeSource, makeFlowing, makeBlock, buildAttributes, ImmutableList.of());
        }

        protected static <S extends IPFluid, F extends IPFluid, B extends IPFluidBlock> IPFluidEntry make(String name, Function<IPFluidEntry, S> makeSource, Function<IPFluidEntry, F> makeFlowing, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> makeBlock, @javax.annotation.Nullable Consumer<FluidType.Properties> buildAttributes, List<Property<?>> properties) {
            return IPFluidEntry.make(name, 0, makeSource, makeFlowing, makeBlock, buildAttributes, properties);
        }

        protected static <S extends IPFluid, F extends IPFluid, B extends IPFluidBlock> IPFluidEntry make(String name, int burnTime, Function<IPFluidEntry, S> makeSource, Function<IPFluidEntry, F> makeFlowing, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> makeBlock, @javax.annotation.Nullable Consumer<FluidType.Properties> buildAttributes, List<Property<?>> properties) {
            FluidType.Properties builder = FluidType.Properties.create();
            if (buildAttributes != null) {
                buildAttributes.accept(builder);
            }
            DeferredHolder<FluidType, CustomFluidType> type = IPRegisters.registerFluidType(name, () -> new CustomFluidType(name, builder));
            MutableObject thisMutable = new MutableObject();
            DeferredHolder<Fluid, IPFluid> source = IPRegisters.registerFluid(name, () -> IPFluidEntry.lambda$make$1(makeSource, (Mutable)thisMutable));
            DeferredHolder<Fluid, IPFluid> flow = IPRegisters.registerFluid(name + "_flowing", () -> IPFluidEntry.lambda$make$2(makeFlowing, (Mutable)thisMutable));
            DeferredHolder<Block, IPFluidBlock> block = IPRegisters.registerBlock(name + "_fluid_block", () -> IPFluidEntry.lambda$make$3(makeBlock, (Mutable)thisMutable));
            DeferredHolder<Item, IPBucketItem> bucket = IPRegisters.registerItem(name + "_bucket", () -> new IPBucketItem((Supplier<? extends Fluid>)source, burnTime));
            IPFluidEntry entry = new IPFluidEntry(source, flow, block, bucket, type, properties);
            thisMutable.setValue((Object)entry);
            FLUIDS.add(entry);
            return entry;
        }

        private static /* synthetic */ IPFluidBlock lambda$make$3(BiFunction makeBlock, Mutable thisMutable) {
            return (IPFluidBlock)((Object)makeBlock.apply((IPFluidEntry)thisMutable.getValue(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noLootTable()));
        }

        private static /* synthetic */ IPFluid lambda$make$2(Function makeFlowing, Mutable thisMutable) {
            return IPFluid.makeFluid(makeFlowing, (IPFluidEntry)thisMutable.getValue());
        }

        private static /* synthetic */ IPFluid lambda$make$1(Function makeSource, Mutable thisMutable) {
            return IPFluid.makeFluid(makeSource, (IPFluidEntry)thisMutable.getValue());
        }
    }

    public static class IPFluidBlock
    extends LiquidBlock {
        private static IPFluidEntry staticEntry;
        protected final IPFluidEntry entry;
        @javax.annotation.Nullable
        private Holder<MobEffect> effect;
        private int duration;
        private int level;

        public IPFluidBlock(IPFluidEntry entry, BlockBehaviour.Properties props) {
            super((FlowingFluid)entry.source().value(), (BlockBehaviour.Properties)Util.make((Object)props, p -> {
                staticEntry = entry;
            }));
            this.entry = entry;
            staticEntry = null;
        }

        public void setEffect(@javax.annotation.Nullable Holder<MobEffect> effect, int duration, int level) {
            this.effect = effect;
            this.duration = duration;
            this.level = level;
        }

        protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
            super.createBlockStateDefinition(builder);
            for (Property<?> p : (this.entry == null ? staticEntry : this.entry).properties()) {
                builder.add(new Property[]{p});
            }
        }

        public FluidState getFluidState(BlockState pState) {
            FluidState state = super.getFluidState(pState);
            for (Property prop : state.getProperties()) {
                if (!pState.hasProperty(prop)) continue;
                state = IPFluidBlock.copyValue(prop, state, pState);
            }
            return state;
        }

        public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
            super.entityInside(pState, pLevel, pPos, pEntity);
            if (this.effect != null && pEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)pEntity;
                living.addEffect(new MobEffectInstance(this.effect, this.duration, this.level));
            }
        }

        public static <S extends StateHolder<?, S>, P extends Comparable<P>> S copyValue(Property<P> prop, S oldState, StateHolder<?, ?> from) {
            return (S)((StateHolder)oldState.setValue(prop, from.getValue(prop)));
        }
    }

    public static class Flowing
    extends IPFluid {
        public Flowing(IPFluidEntry entry) {
            super(entry);
        }

        @Override
        protected void createFluidStateDefinition(@Nonnull StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }
    }

    public static class IPBucketItem
    extends BucketItem
    implements IPCreativeTab.IMightShowUpInCreativeTab {
        private static final Item.Properties PROPS = new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET);
        private int burnTime;

        public IPBucketItem(Supplier<? extends Fluid> fluid, int burnTime) {
            super(fluid.get(), PROPS);
            this.burnTime = burnTime;
        }

        public IPBucketItem(Supplier<? extends Fluid> fluid, Function<Item.Properties, Item.Properties> props) {
            super(fluid.get(), props.apply(PROPS));
        }

        public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
            return this.burnTime;
        }
    }

    private static class CustomFluidType
    extends FluidType {
        final ResourceLocation stillTexture;
        final ResourceLocation flowTexture;

        public CustomFluidType(String name, FluidType.Properties properties) {
            super(properties);
            this.stillTexture = ResourceUtils.ip("block/fluid/" + name + "_still");
            this.flowTexture = ResourceUtils.ip("block/fluid/" + name + "_flow");
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowTexture;
                }
            });
        }

        public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
            if (!(state.getType() instanceof IPFluid)) {
                return false;
            }
            IPFluid ipFluid = (IPFluid)state.getType();
            if (!ipFluid.hasCustomSlowdown()) {
                return false;
            }
            double drag = ipFluid.getEntitySlowdown();
            boolean isFalling = entity.getDeltaMovement().y <= 0.0;
            double y = entity.getY();
            double walkSpeed = entity.isSprinting() ? drag * 1.125 : drag;
            double swimSpeed = 0.02f;
            entity.moveRelative((float)(swimSpeed *= entity.getAttribute(NeoForgeMod.SWIM_SPEED).getValue()), movementVector);
            entity.move(MoverType.SELF, entity.getDeltaMovement());
            Vec3 deltaMovment = entity.getDeltaMovement();
            if (entity.horizontalCollision && entity.onClimbable()) {
                deltaMovment = new Vec3(deltaMovment.x, 0.2, deltaMovment.z);
            }
            entity.setDeltaMovement(deltaMovment.multiply(walkSpeed, drag, walkSpeed));
            Vec3 vec32 = entity.getFluidFallingAdjustedMovement(gravity, isFalling, entity.getDeltaMovement());
            entity.setDeltaMovement(vec32);
            if (entity.horizontalCollision && entity.isFree(vec32.x, vec32.y + 0.6 - entity.getY() + y, vec32.z)) {
                entity.setDeltaMovement(vec32.x, 0.3, vec32.z);
            }
            return true;
        }
    }
}

