/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.entity;

import blusunrize.immersiveengineering.common.util.IESounds;
import com.google.common.collect.Lists;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPDataComponents;
import flaxbeard.immersivepetroleum.common.entity.IPEntityTypes;
import flaxbeard.immersivepetroleum.common.items.DebugItem;
import flaxbeard.immersivepetroleum.common.items.GasolineBottleItem;
import flaxbeard.immersivepetroleum.common.items.MotorboatItem;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.network.MessageConsumeBoatFuel;
import flaxbeard.immersivepetroleum.common.sound.IPlaySound;
import flaxbeard.immersivepetroleum.common.util.IPItemStackContainerHandler;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.mixin.accessors.BoatAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MotorboatEntity
extends Boat
implements IEntityWithComplexSpawn,
IPlaySound {
    static final EntityDataAccessor<String> TANK_FLUID = SynchedEntityData.defineId(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    static final EntityDataAccessor<Integer> TANK_AMOUNT = SynchedEntityData.defineId(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    static final EntityDataAccessor<ItemStack>[] UPGRADES = new EntityDataAccessor[3];
    public boolean isFireproof = false;
    public boolean hasIcebreaker = false;
    public boolean hasTank = false;
    public boolean hasRudders = false;
    public boolean hasPaddles = false;
    public boolean isBoosting = false;
    public float lastMoving;
    public InterpolatableFloat propellerAssemblyRotation = new InterpolatableFloat();
    public InterpolatableFloat propellerRotation = new InterpolatableFloat();
    public float propellerRotationSpeed = 0.0f;
    private BoatTank tank;
    protected float oYRot;
    protected boolean fastEnough;
    protected int oFuelAmount;

    public MotorboatEntity(Level world) {
        this((EntityType<MotorboatEntity>)((EntityType)IPEntityTypes.MOTORBOAT.get()), world);
    }

    public MotorboatEntity(Level world, double x, double y, double z) {
        this((EntityType<MotorboatEntity>)((EntityType)IPEntityTypes.MOTORBOAT.get()), world);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public MotorboatEntity(EntityType<MotorboatEntity> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    protected void defineSynchedData(@Nonnull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        this.tank = new BoatTank(this, builder);
        for (EntityDataAccessor<ItemStack> upgrade : UPGRADES) {
            builder.define(upgrade, (Object)ItemStack.EMPTY);
        }
    }

    protected void readAdditionalSaveData(@Nonnull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.tank.readAdditional(compound);
        ItemStack[] array = new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY};
        if (compound.contains("upgrades")) {
            CompoundTag upgrades = compound.getCompound("upgrades");
            for (int i = 0; i < array.length; ++i) {
                Optional parsed = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)upgrades.getCompound(Integer.toString(i)));
                if (!parsed.isPresent()) continue;
                array[i] = (ItemStack)parsed.get();
            }
        }
        this.setUpgrades(array);
    }

    protected void addAdditionalSaveData(@Nonnull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.tank.writeAdditional(tag);
        CompoundTag upgrades = new CompoundTag();
        ItemStack[] array = (ItemStack[])this.getUpgrades().toArray(ItemStack[]::new);
        for (int i = 0; i < array.length; ++i) {
            if (array[i].isEmpty()) continue;
            upgrades.put(Integer.toString(i), array[i].save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
        tag.put("upgrades", (Tag)upgrades);
    }

    public void setUpgrades(NonNullList<ItemStack> stacks) {
        if (stacks != null && !stacks.isEmpty()) {
            ItemStack[] array = (ItemStack[])stacks.toArray(ItemStack[]::new);
            this.setUpgrades(array);
        }
    }

    public boolean isForwardDown() {
        return this.access().isInputUp();
    }

    public boolean isLeftDown() {
        return this.access().isInputLeft();
    }

    public boolean isReverseDown() {
        return this.access().isInputDown();
    }

    public boolean isRightDown() {
        return this.access().isInputRight();
    }

    public void onSyncedDataUpdated(@Nonnull EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        boolean any = Arrays.stream(UPGRADES).anyMatch(upgrade -> key == upgrade);
        if (any) {
            this.isFireproof = false;
            this.hasIcebreaker = false;
            NonNullList<ItemStack> upgrades = this.getUpgrades();
            for (ItemStack upgrade2 : upgrades) {
                if (upgrade2 == null || upgrade2.isEmpty()) continue;
                Item item = upgrade2.getItem();
                if (item == IPContent.BoatUpgrades.REINFORCED_HULL.get()) {
                    this.isFireproof = true;
                    continue;
                }
                if (item == IPContent.BoatUpgrades.ICE_BREAKER.get()) {
                    this.hasIcebreaker = true;
                    continue;
                }
                if (item == IPContent.BoatUpgrades.TANK.get()) {
                    this.hasTank = true;
                    continue;
                }
                if (item == IPContent.BoatUpgrades.RUDDERS.get()) {
                    this.hasRudders = true;
                    continue;
                }
                if (item != IPContent.BoatUpgrades.PADDLES.get()) continue;
                this.hasPaddles = true;
            }
        }
        this.tank.updateCapacity();
    }

    public void setContainedFluid(FluidStack stack) {
        this.tank.setData(stack);
    }

    public IFluidTank getTank() {
        return this.tank.getInternalTank();
    }

    public boolean isClient() {
        return this.level().isClientSide;
    }

    public boolean isServer() {
        return !this.level().isClientSide;
    }

    public float getSinglePassengerXOffset() {
        return 0.05f;
    }

    @Nonnull
    public Vec3 getDismountLocationForPassenger(LivingEntity pLivingEntity) {
        Vec3 vec3 = MotorboatEntity.getCollisionHorizontalEscapeVector((double)(this.getBbWidth() * Mth.SQRT_OF_TWO), (double)pLivingEntity.getBbWidth(), (float)pLivingEntity.getYRot());
        double d0 = this.getX() + vec3.x;
        double d1 = this.getZ() + vec3.z;
        BlockPos blockpos = BlockPos.containing((double)d0, (double)this.getBoundingBox().maxY, (double)d1);
        BlockPos blockpos1 = blockpos.below();
        if (!this.level().isWaterAt(blockpos1) && !this.level().getFluidState(blockpos1).is(FluidTags.LAVA)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.level().getBlockFloorHeight(blockpos);
            if (DismountHelper.isBlockFloorValid((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.getY() + d2, d1));
            }
            if (DismountHelper.isBlockFloorValid((double)(d3 = this.level().getBlockFloorHeight(blockpos1)))) {
                list.add(new Vec3(d0, (double)blockpos1.getY() + d3, d1));
            }
            for (Pose pose : pLivingEntity.getDismountPoses()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (Vec3)vec31, (LivingEntity)pLivingEntity, (Pose)pose)) continue;
                    pLivingEntity.setPose(pose);
                    return vec31;
                }
            }
        }
        return new Vec3(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    public boolean hurt(@Nonnull DamageSource source, float amount) {
        if (this.isInvulnerableTo(source) || this.isFireproof && source.is(DamageTypeTags.IS_FIRE)) {
            return false;
        }
        if (this.isServer() && this.isAlive()) {
            boolean isCreativePlayer;
            if (!source.isDirect() && source.getDirectEntity() != null && this.hasPassenger(source.getDirectEntity())) {
                return false;
            }
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.markHurt();
            boolean isPlayer = source.getDirectEntity() instanceof Player;
            boolean bl = isCreativePlayer = isPlayer && ((Player)source.getDirectEntity()).getAbilities().instabuild;
            if ((isCreativePlayer || this.getDamage() > 40.0f) && (!this.isFireproof || isPlayer) || this.getDamage() > 240.0f) {
                if (!isCreativePlayer && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    IItemHandler itemHandler;
                    MotorboatItem item = (MotorboatItem)this.getDropItem();
                    ItemStack stack = new ItemStack((ItemLike)item, 1);
                    FluidStack fs = this.getTank().getFluid();
                    if (!fs.isEmpty()) {
                        stack.set(IPDataComponents.TANK_DATA, (Object)new IPDataComponents.TankData(fs));
                    }
                    if ((itemHandler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM)) != null && itemHandler instanceof IPItemStackContainerHandler) {
                        NonNullList<ItemStack> upgrades = this.getUpgrades();
                        for (int i = 0; i < itemHandler.getSlots(); ++i) {
                            itemHandler.insertItem(i, (ItemStack)upgrades.get(i), false);
                        }
                    }
                    if (isPlayer) {
                        Player player = (Player)source.getDirectEntity();
                        if (!player.addItem(stack)) {
                            ItemEntity itemEntity = new ItemEntity(this.level(), player.getX(), player.getY(), player.getZ(), stack);
                            itemEntity.setNoPickUpDelay();
                            this.level().addFreshEntity((Entity)itemEntity);
                        }
                    } else {
                        this.spawnAtLocation(stack, 0.0f);
                    }
                }
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return true;
    }

    @Nonnull
    public InteractionResult interact(Player player, @Nonnull InteractionHand hand) {
        Item tank;
        Item item;
        ItemStack stack = player.getItemInHand(hand);
        if (stack != ItemStack.EMPTY && (item = stack.getItem()) instanceof DebugItem) {
            DebugItem debugItem = (DebugItem)item;
            debugItem.onSpeedboatClick(this, player, stack);
            return InteractionResult.SUCCESS;
        }
        if (Utils.isFluidRelatedItemStack(stack)) {
            FluidStack fStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(null);
            if (fStack != null && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank.getHandler())) {
                tank = this.getInternalTank();
                this.setContainedFluid(tank.getFluid());
                this.advancement((IFluidTank)tank, fStack, player);
            }
            return InteractionResult.SUCCESS;
        }
        tank = stack.getItem();
        if (tank instanceof GasolineBottleItem) {
            FluidStack fStack;
            GasolineBottleItem gasolineBottle = (GasolineBottleItem)tank;
            tank = this.getInternalTank();
            if (tank.fill(fStack = new FluidStack(IPContent.Fluids.GASOLINE.get(), 250), IFluidHandler.FluidAction.SIMULATE) >= 250) {
                tank.fill(fStack, IFluidHandler.FluidAction.EXECUTE);
                gasolineBottle.toEmptyBottle(player, stack);
                this.setContainedFluid(tank.getFluid());
                this.advancement((IFluidTank)tank, fStack, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isServer() && !player.isShiftKeyDown() && this.access().getOutOfControlTicks() < 60.0f && !player.isPassengerOfSameVehicle((Entity)this)) {
            player.startRiding((Entity)this);
            if (this.level().dimension().equals(Level.NETHER) && this.isFireproof) {
                Utils.unlockIPAdvancement(player, "main/reinforced_hull");
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private IFluidTank getInternalTank() {
        return this.tank.getInternalTank();
    }

    private void advancement(IFluidTank tank, FluidStack fstack, Player player) {
        if (tank.isFluidValid(fstack)) {
            Utils.unlockIPAdvancement(player, "main/motorboat");
            if (this.hasTank && tank.getFluidAmount() == tank.getCapacity()) {
                Utils.unlockIPAdvancement(player, "main/tank");
            }
        }
    }

    public void setInput(boolean pLeftInputDown, boolean pRightInputDown, boolean pForwardInputDown, boolean pBackInputDown) {
        super.setInput(pLeftInputDown, pRightInputDown, pForwardInputDown, pBackInputDown);
        this.isBoosting = !this.isEmergency() && pForwardInputDown && Minecraft.getInstance().options.keyJump.isDown();
    }

    public boolean isSpinningFastEnough() {
        return this.fastEnough;
    }

    private void updateAdvancementConditions() {
        Entity entity;
        if (this.isClient()) {
            return;
        }
        this.fastEnough = Math.abs(this.getYRot() - this.oYRot) >= 5.0f;
        this.oYRot = this.getYRot();
        int current = this.getTank().getFluidAmount();
        if (current - this.oFuelAmount != 0 && current == 0 && (entity = this.getFirstPassenger()) instanceof Player) {
            Player player = (Player)entity;
            if (this.hasPaddles) {
                Utils.unlockIPAdvancement(player, "main/paddles");
            }
        }
        this.oFuelAmount = current;
    }

    private void incrementOutOfControlTicks() {
        BoatAccess access = this.access();
        access.setOutOfControlTicks(access.getOutOfControlTicks() + 1.0f);
    }

    public void tick() {
        List list;
        this.updateAdvancementConditions();
        this.propellerAssemblyRotation.update();
        this.propellerRotation.update();
        BoatAccess boatAccess = this.access();
        Boat.Status newStatus = boatAccess.invokeGetStatus();
        boatAccess.oldStatus(boatAccess.status());
        boatAccess.status(newStatus);
        if (boatAccess.status() != Boat.Status.UNDER_WATER && boatAccess.status() != Boat.Status.UNDER_FLOWING_WATER) {
            boatAccess.setOutOfControlTicks(0.0f);
        } else {
            this.incrementOutOfControlTicks();
        }
        if (this.isServer() && boatAccess.getOutOfControlTicks() >= 60.0f) {
            this.ejectPassengers();
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        this.baseTick();
        boatAccess.invokeTickLerp();
        if (this.isControlledByLocalInstance()) {
            if (!(this.getFirstPassenger() instanceof Player)) {
                this.setPaddleState(false, false);
            }
            boatAccess.invokeFloatBoat();
            if (this.isClient()) {
                this.controlBoat();
                this.level().sendPacketToServer((Packet)new ServerboundPaddleBoatPacket(this.getPaddleState(0), this.getPaddleState(1)));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
        } else {
            this.setDeltaMovement(Vec3.ZERO);
        }
        boatAccess.invokeTickBubbleColumn();
        if (this.isClient() && !this.isEmergency()) {
            float yO;
            float zO;
            float xO;
            float moving;
            float f = this.isForwardDown() || this.isReverseDown() ? (this.isBoosting ? 0.9f : 0.7f) : (moving = 0.5f);
            if (this.lastMoving != moving) {
                this.lastMoving = moving;
                ImmersivePetroleum.proxy.handleEntitySound((Holder<SoundEvent>)IESounds.dieselGenerator, (Entity)this, false, 0.0f, 0.0f);
            }
            FluidStack fs = this.getTank().getFluid();
            boolean isActive = this.getControllingPassenger() instanceof Player && fs != FluidStack.EMPTY && fs.getAmount() > 0;
            ImmersivePetroleum.proxy.handleEntitySound((Holder<SoundEvent>)IESounds.dieselGenerator, (Entity)this, isActive, this.isForwardDown() || this.isReverseDown() ? 0.5f : 0.3f, moving);
            if (this.isForwardDown()) {
                xO = Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) + (this.level().random.nextFloat() - 0.5f) * 0.3f;
                zO = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) + (this.level().random.nextFloat() - 0.5f) * 0.3f;
                if (this.isInLava()) {
                    if (this.level().random.nextInt(3) == 0) {
                        yO = 0.4f + (this.level().random.nextFloat() - 0.5f) * 0.3f;
                        Vec3 motion = this.getDeltaMovement();
                        this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, this.getX() - (double)(xO * 1.5f), this.getY() + (double)yO, this.getZ() - (double)(zO * 1.5f), -2.0 * motion.x(), 0.0, -2.0 * motion.z());
                    }
                } else {
                    yO = 0.1f + (this.level().random.nextFloat() - 0.5f) * 0.3f;
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - (double)(xO * 1.5f), this.getY() + (double)yO, this.getZ() - (double)(zO * 1.5f), 0.0, 0.0, 0.0);
                }
            }
            if (this.isBoosting && this.level().random.nextInt(2) == 0) {
                xO = Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) + (this.level().random.nextFloat() - 0.5f) * 0.3f;
                zO = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) + (this.level().random.nextFloat() - 0.5f) * 0.3f;
                yO = 0.8f + (this.level().random.nextFloat() - 0.5f) * 0.3f;
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() - (double)(xO * 1.3f), this.getY() + (double)yO, this.getZ() - (double)(zO * 1.3f), 0.0, 0.0, 0.0);
            }
        }
        float[] paddlePositions = boatAccess.getPaddlePositions();
        if (this.isEmergency()) {
            for (int i = 0; i <= 1; ++i) {
                if (this.getPaddleState(i)) {
                    SoundEvent soundevent;
                    if (!this.isSilent() && (double)(paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && (double)((paddlePositions[i] + 0.3926991f) % ((float)Math.PI * 2)) >= 0.7853981852531433 && (soundevent = this.getPaddleSound()) != null) {
                        Vec3 vec3 = this.getViewVector(1.0f);
                        double d0 = i == 1 ? -vec3.z : vec3.z;
                        double d1 = i == 1 ? vec3.x : -vec3.x;
                        this.level().playSound(null, this.getX() + d0, this.getY(), this.getZ() + d1, soundevent, this.getSoundSource(), 1.0f, 0.8f + 0.4f * this.random.nextFloat());
                        this.level().gameEvent((Entity)this.getControllingPassenger(), (Holder)GameEvent.SPLASH, BlockPos.containing((double)(this.getX() + d0), (double)this.getY(), (double)(this.getZ() + d1)));
                    }
                    int n = i;
                    paddlePositions[n] = paddlePositions[n] + 0.3926991f;
                    continue;
                }
                paddlePositions[i] = 0.0f;
            }
        } else if (this.getPaddleState(0)) {
            paddlePositions[0] = paddlePositions[0] + (this.isBoosting ? 0.02f : 0.01f);
        } else if (this.getPaddleState(1)) {
            paddlePositions[0] = paddlePositions[0] - 0.01f;
        }
        float xO = Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180)));
        float zO = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
        Vector3f vec = new Vector3f(xO, zO, 0.0f);
        vec.normalize();
        if (this.isServer() && this.hasIcebreaker && !this.isEmergency()) {
            AABB bb = this.getBoundingBox().inflate(0.1);
            BlockPos.MutableBlockPos mutableBlockPos0 = new BlockPos.MutableBlockPos(bb.minX + 0.001, bb.minY + 0.001, bb.minZ + 0.001);
            BlockPos.MutableBlockPos mutableBlockPos1 = new BlockPos.MutableBlockPos(bb.maxX - 0.001, bb.maxY - 0.001, bb.maxZ - 0.001);
            BlockPos.MutableBlockPos mutableBlockPos2 = new BlockPos.MutableBlockPos();
            if (this.level().hasChunksAt((BlockPos)mutableBlockPos0, (BlockPos)mutableBlockPos1)) {
                Entity j2;
                boolean brokeIce = false;
                for (int i = mutableBlockPos0.getX(); i <= mutableBlockPos1.getX(); ++i) {
                    for (int j2 = mutableBlockPos0.getY(); j2 <= mutableBlockPos1.getY(); ++j2) {
                        for (int k = mutableBlockPos0.getZ(); k <= mutableBlockPos1.getZ(); ++k) {
                            mutableBlockPos2.set(i, j2, k);
                            BlockState BlockState2 = this.level().getBlockState((BlockPos)mutableBlockPos2);
                            Vector3f vec2 = new Vector3f((float)((double)((float)i + 0.5f) - this.getX()), (float)((double)((float)k + 0.5f) - this.getZ()), 0.0f);
                            vec2.normalize();
                            float sim = vec2.dot((Vector3fc)vec);
                            if (BlockState2.getBlock() != Blocks.ICE || !(sim > 0.3f)) continue;
                            this.level().destroyBlock((BlockPos)mutableBlockPos2, false);
                            this.level().setBlockAndUpdate((BlockPos)mutableBlockPos2, Blocks.WATER.defaultBlockState());
                            brokeIce = true;
                        }
                    }
                }
                if (brokeIce && (j2 = this.getFirstPassenger()) instanceof Player) {
                    Player player = (Player)j2;
                    Utils.unlockIPAdvancement(player, "main/ice_breaker");
                }
            }
        }
        this.checkInsideBlocks();
        if (this.isServer() && !(list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.pushableBy((Entity)this))).isEmpty()) {
            boolean flag = !(this.getControllingPassenger() instanceof Player);
            for (Entity entity : list) {
                LivingEntity player;
                if (entity.hasPassenger((Entity)this)) continue;
                if (flag && this.getPassengers().size() < 2 && !entity.isPassenger() && entity.getBbWidth() < this.getBbWidth() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.startRiding((Entity)this);
                    continue;
                }
                this.push(entity);
                if (!this.hasIcebreaker || !(entity instanceof LivingEntity) || entity instanceof Player || !((player = this.getControllingPassenger()) instanceof Player)) continue;
                Player player2 = (Player)player;
                Vector3f vec2 = new Vector3f((float)(entity.getX() - this.getX()), (float)(entity.getZ() - this.getZ()), 0.0f);
                vec2.normalize();
                float sim = vec2.dot((Vector3fc)vec);
                if (!(sim > 0.5f)) continue;
                Vec3 motion = entity.getDeltaMovement();
                entity.hurt(this.level().damageSources().playerAttack(player2), 4.0f);
                entity.setDeltaMovement(new Vec3(motion.x + (double)(vec2.x() * 0.75f), motion.y, motion.z + (double)(vec2.y() * 0.75f)));
            }
        }
        this.propellerRotation.set((this.propellerRotation.get() + this.propellerRotationSpeed) % 360.0f);
        if (this.propellerRotationSpeed != 0.0f) {
            this.propellerRotationSpeed *= 0.9f;
            if (Math.abs(this.propellerRotationSpeed) <= 0.1f) {
                this.propellerRotationSpeed = 0.0f;
            }
        }
    }

    private void addDeltaRotation(BoatAccess boatAccess, float amount) {
        boatAccess.setDeltaRotation(boatAccess.getDeltaRotation() + amount);
    }

    protected void controlBoat() {
        if (!this.isVehicle()) {
            return;
        }
        BoatAccess boatAccess = this.access();
        float movMagnitude = 0.0f;
        if (this.isEmergency()) {
            if (this.isLeftDown()) {
                this.addDeltaRotation(boatAccess, -1.0f);
            }
            if (this.isRightDown()) {
                this.addDeltaRotation(boatAccess, 1.0f);
            }
            if (this.isRightDown() != this.isLeftDown() && !this.isForwardDown() && !this.isReverseDown()) {
                movMagnitude += 0.005f;
            }
            this.setYRot(this.getYRot() + boatAccess.getDeltaRotation());
            if (this.isForwardDown()) {
                movMagnitude += 0.04f;
            }
            if (this.isReverseDown()) {
                movMagnitude -= 0.005f;
            }
            this.addMovement(movMagnitude);
        } else {
            FluidStack fluid = this.getTank().getFluid();
            int consumeAmount = 0;
            if (fluid != FluidStack.EMPTY) {
                consumeAmount = FuelHandler.getBoatFuelUse(fluid.getFluid());
            }
            if (fluid != FluidStack.EMPTY && fluid.getAmount() >= consumeAmount && (this.isForwardDown() || this.isReverseDown())) {
                int toConsume = consumeAmount;
                if (this.isForwardDown()) {
                    movMagnitude += 0.05f;
                    if (this.isBoosting && fluid.getAmount() >= 3 * consumeAmount) {
                        movMagnitude *= 1.6f;
                        toConsume *= 3;
                    }
                }
                if (this.isReverseDown()) {
                    movMagnitude -= 0.01f;
                }
                if (this.isForwardDown()) {
                    this.propellerRotationSpeed += this.isBoosting ? 10.0f : 5.5f;
                } else if (this.isReverseDown()) {
                    this.propellerRotationSpeed -= 5.5f;
                }
                fluid.setAmount(Math.max(0, fluid.getAmount() - toConsume));
                this.setContainedFluid(fluid);
                IPPacketHandler.sendToServer(new MessageConsumeBoatFuel(toConsume));
                this.setPaddleState(this.isForwardDown(), this.isReverseDown());
            } else {
                this.setPaddleState(false, false);
            }
            Vec3 motion = this.addMovement(movMagnitude);
            if (this.isLeftDown() || this.isRightDown()) {
                float speed = (float)Math.sqrt(motion.x * motion.x + motion.z * motion.z);
                float delta = 1.1f * speed * (this.hasRudders ? 1.5f : 1.0f) * (this.isBoosting ? 0.5f : 1.0f) * (this.isReverseDown() && !this.isForwardDown() ? 2.0f : 1.0f);
                if (this.isRightDown()) {
                    this.addDeltaRotation(boatAccess, delta);
                    this.propellerAssemblyRotation.setClamped(this.propellerAssemblyRotation.get() - 0.2f, -1.0f, 1.0f);
                }
                if (this.isLeftDown()) {
                    this.addDeltaRotation(boatAccess, -delta);
                    this.propellerAssemblyRotation.setClamped(this.propellerAssemblyRotation.get() + 0.2f, -1.0f, 1.0f);
                }
            }
            if (!this.isLeftDown() && !this.isRightDown() && this.propellerAssemblyRotation.get() != 0.0f) {
                this.propellerAssemblyRotation.set(this.propellerAssemblyRotation.get() * 0.7f);
                if (Math.abs(this.propellerAssemblyRotation.get()) < 0.01f) {
                    this.propellerAssemblyRotation.set(0.0f);
                }
            }
            this.setYRot(this.getYRot() + boatAccess.getDeltaRotation());
        }
        this.setPaddleState(this.isRightDown() && !this.isLeftDown() || this.isForwardDown(), this.isLeftDown() && !this.isRightDown() || this.isForwardDown());
    }

    private Vec3 addMovement(float magnitude) {
        double xa = Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) * magnitude;
        double za = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * magnitude;
        Vec3 motion = this.getDeltaMovement().add(xa, 0.0, za);
        this.setDeltaMovement(motion);
        return motion;
    }

    public int getMaxFuel() {
        return this.hasTank ? 16000 : 8000;
    }

    @Nonnull
    public Item getDropItem() {
        return (Item)IPContent.Items.SPEEDBOAT.get();
    }

    public boolean isOnFire() {
        if (this.isFireproof) {
            return false;
        }
        return super.isOnFire();
    }

    public boolean isEmergency() {
        FluidStack fluid = this.getTank().getFluid();
        if (fluid.isEmpty()) {
            return this.hasPaddles;
        }
        int consumeAmount = FuelHandler.getBoatFuelUse(fluid.getFluid());
        return fluid.getAmount() < consumeAmount && this.hasPaddles;
    }

    public NonNullList<ItemStack> getUpgrades() {
        NonNullList stackList = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
        for (int i = 0; i < 3; ++i) {
            stackList.set(i, (Object)((ItemStack)this.entityData.get(UPGRADES[i])));
        }
        return stackList;
    }

    public String[] getOverlayText(Player player, HitResult hit) {
        if (Utils.isFluidRelatedItemStack(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            FluidStack stack = this.getTank().getFluid();
            Object s = stack != FluidStack.EMPTY ? stack.getHoverName().getString() + ": " + stack.getAmount() + "mB" : I18n.get((String)"gui.immersivepetroleum.empty", (Object[])new Object[0]);
            return new String[]{s};
        }
        return null;
    }

    public boolean canBoatInFluid(@Nonnull FluidState state) {
        return super.canBoatInFluid(state) || this.isLavaProof(state);
    }

    private boolean isLavaProof(FluidState fState) {
        return this.isFireproof && fState.is(FluidTags.LAVA);
    }

    public boolean getSharedFlag(int flag) {
        return super.getSharedFlag(flag);
    }

    public void setSharedFlag(int flag, boolean set) {
        super.setSharedFlag(flag, set);
    }

    public void readSpawnData(@Nonnull RegistryFriendlyByteBuf buffer) {
        this.tank.readSpawnData(buffer);
        ItemStack[] array = new ItemStack[3];
        for (int i = 0; i < array.length; ++i) {
            byte s = buffer.readByte();
            array[i] = s > 0 ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer) : ItemStack.EMPTY;
        }
        this.setUpgrades(array);
    }

    public void writeSpawnData(@Nonnull RegistryFriendlyByteBuf buffer) {
        this.tank.writeSpawnData(buffer);
        for (ItemStack stack : this.getUpgrades()) {
            boolean notEmpty = !stack.isEmpty();
            buffer.writeByte(notEmpty ? 1 : 0);
            if (!notEmpty) continue;
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)stack);
        }
    }

    private void setUpgrades(ItemStack ... array) {
        if (array.length != 3) {
            ItemStack[] nArray = new ItemStack[3];
            System.arraycopy(array, 0, nArray, 0, nArray.length);
            array = nArray;
        }
        for (int i = 0; i < 3; ++i) {
            this.entityData.set(UPGRADES[i], (Object)array[i]);
        }
    }

    @Override
    public boolean stopSound(ResourceLocation soundLocation) {
        return this.isEmergency();
    }

    protected BoatAccess access() {
        return (BoatAccess)((Object)this);
    }

    static {
        for (int i = 0; i < 3; ++i) {
            MotorboatEntity.UPGRADES[i] = SynchedEntityData.defineId(MotorboatEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
        }
    }

    public static class InterpolatableFloat {
        private float _new = 0.0f;
        private float _old = 0.0f;

        InterpolatableFloat() {
        }

        public void set(float value) {
            this._new = value;
        }

        public void setClamped(float value, float min, float max) {
            this._new = Math.clamp(value, min, max);
        }

        public void update() {
            this._old = this._new;
        }

        public float lerp(float v) {
            return Mth.lerp((float)v, (float)this._old, (float)this._new);
        }

        public float rotLerp(float v) {
            return Mth.rotLerp((float)v, (float)this._old, (float)this._new);
        }

        public float get() {
            return this._new;
        }

        public float getOld() {
            return this._old;
        }
    }

    public static class BoatTank {
        private final FluidTank tank;
        private final MotorboatEntity boat;

        public BoatTank(MotorboatEntity boat, @Nonnull SynchedEntityData.Builder builder) {
            this.boat = boat;
            this.tank = new FluidTank(boat.getMaxFuel(), e -> FuelHandler.isValidBoatFuel(e.getFluid())){

                protected void onContentsChanged() {
                    this.setData(this.getFluid());
                }
            };
            builder.define(TANK_FLUID, (Object)"");
            builder.define(TANK_AMOUNT, (Object)0);
        }

        private void readAdditional(@Nonnull CompoundTag tag) {
            FluidStack stack = FluidStack.parseOptional((HolderLookup.Provider)this.boat.registryAccess(), (CompoundTag)tag.getCompound("fluid"));
            this.setData(stack);
            this.tank.setFluid(stack);
        }

        private void writeAdditional(@Nonnull CompoundTag ret) {
            Tag fluidTag = this.tank.getFluid().saveOptional((HolderLookup.Provider)this.boat.registryAccess());
            ret.put("fluid", fluidTag);
        }

        private void readSpawnData(@Nonnull RegistryFriendlyByteBuf buffer) {
            String fluid = buffer.readUtf();
            int amount = buffer.readInt();
            this.setData(fluid, amount);
            this.syncTankFromEntityData();
        }

        private void writeSpawnData(@Nonnull RegistryFriendlyByteBuf buffer) {
            String fluid = (String)this.boat.entityData.get(TANK_FLUID);
            int amount = (Integer)this.boat.entityData.get(TANK_AMOUNT);
            buffer.writeUtf(fluid);
            buffer.writeInt(amount);
        }

        public void updateCapacity() {
            this.tank.setCapacity(this.boat.getMaxFuel());
        }

        public IFluidTank getInternalTank() {
            return this.tank;
        }

        public IFluidHandler getHandler() {
            return this.tank;
        }

        private void syncTankFromEntityData() {
            this.tank.setFluid(this.getData());
        }

        private void setData(@Nonnull FluidStack stack) {
            if (stack.isEmpty()) {
                this.setData("", 0);
                return;
            }
            String fluidStr = RegistryUtils.getRegistryNameOf(stack.getFluid()).toString();
            int amount = stack.getAmount();
            this.setData(fluidStr, amount);
            this.syncTankFromEntityData();
        }

        private void setData(String fluidStr, int amount) {
            this.boat.entityData.set(TANK_FLUID, (Object)fluidStr);
            this.boat.entityData.set(TANK_AMOUNT, (Object)amount);
        }

        private FluidStack getData() {
            Fluid fluid;
            String fluidStr = (String)this.boat.entityData.get(TANK_FLUID);
            int amount = (Integer)this.boat.entityData.get(TANK_AMOUNT);
            FluidStack stack = FluidStack.EMPTY;
            if (amount > 0 && !fluidStr.isEmpty() && (fluid = RegistryUtils.getFluidFromRegistryName(ResourceLocation.parse((String)fluidStr))) != null) {
                stack = new FluidStack(fluid, amount);
            }
            return stack;
        }
    }
}

