/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.entity;

import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.entity.IPEntityTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MolotovItemEntity
extends ThrowableItemProjectile {
    public MolotovItemEntity(Level world, LivingEntity living) {
        this((EntityType<MolotovItemEntity>)((EntityType)IPEntityTypes.MOLOTOV.get()), world, living);
    }

    public MolotovItemEntity(EntityType<MolotovItemEntity> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public MolotovItemEntity(EntityType<MolotovItemEntity> type, Level world, LivingEntity living) {
        super(type, living, world);
        this.blocksBuilding = true;
    }

    @Nonnull
    protected Item getDefaultItem() {
        return (Item)IPContent.Items.MOLOTOV_LIT.get();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            double m = 0.125;
            double x = this.getX() + (m - m * 2.0 * this.random.nextDouble());
            double y = this.getY() + (m - m * 2.0 * this.random.nextDouble());
            double z = this.getZ() + (m - m * 2.0 * this.random.nextDouble());
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void onHit(@Nonnull HitResult pResult) {
        super.onHit(pResult);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    protected void onHitEntity(@Nonnull EntityHitResult pResult) {
        super.onHitEntity(pResult);
        if (!this.level().isClientSide) {
            this.fire(BlockPos.containing((Position)pResult.getLocation()));
        }
    }

    protected void onHitBlock(@Nonnull BlockHitResult hitResult) {
        super.onHitBlock(hitResult);
        if (!this.level().isClientSide) {
            this.fire(hitResult.getBlockPos().relative(hitResult.getDirection()));
        }
    }

    private void fire(BlockPos pos) {
        if (!this.level().getFluidState(pos).isEmpty()) {
            this.level().playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, this.level().getRandom().nextFloat() * 0.4f + 0.8f);
            return;
        }
        this.level().playSound(null, pos, SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 0.3f, 0.7f);
        HashSet<BlockPos> hits = new HashSet<BlockPos>();
        this.scanArea(pos, pos, hits, 9);
        if (hits.isEmpty()) {
            return;
        }
        hits.forEach(this::placeFire);
        this.level().playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.NEUTRAL, 1.0f, 1.0f);
        AABB bounds = AABB.ofSize((Vec3)new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (double)6.5, (double)6.5, (double)6.5);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, bounds);
        if (list.isEmpty()) {
            return;
        }
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            DamageSource src = this.level().damageSources().playerAttack(player);
            list.forEach(e -> e.hurt(src, 1.0f));
        }
        if ((entity = this.getOwner()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.setLastHurtMob((Entity)list.getLast());
        }
    }

    private void scanArea(BlockPos start, BlockPos pos, Set<BlockPos> visited, int radiusSqr) {
        BlockPos dif = pos.subtract((Vec3i)start);
        int sqr = dif.getX() * dif.getX() + dif.getY() * dif.getY() + dif.getZ() * dif.getZ();
        if (sqr > radiusSqr) {
            return;
        }
        if (pos != start && !this.level().getBlockState(pos).isAir()) {
            return;
        }
        if (visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        this.scanArea(start, pos.above(), visited, radiusSqr);
        this.scanArea(start, pos.below(), visited, radiusSqr);
        this.scanArea(start, pos.north(), visited, radiusSqr);
        this.scanArea(start, pos.east(), visited, radiusSqr);
        this.scanArea(start, pos.south(), visited, radiusSqr);
        this.scanArea(start, pos.west(), visited, radiusSqr);
    }

    private void placeFire(BlockPos pos) {
        if (!this.level().getBlockState(pos).isAir()) {
            return;
        }
        BlockState fire = Blocks.FIRE.defaultBlockState();
        if (this.level().getBlockState(pos.below()).isAir()) {
            BlockPos abovePos = pos.above();
            BlockPos northPos = pos.north();
            BlockPos eastPos = pos.east();
            BlockPos southPos = pos.south();
            BlockPos westPos = pos.west();
            boolean up = this.level().getBlockState(abovePos).isFlammable((BlockGetter)this.level(), abovePos, Direction.DOWN);
            boolean north = this.level().getBlockState(northPos).isFlammable((BlockGetter)this.level(), northPos, Direction.SOUTH);
            boolean east = this.level().getBlockState(eastPos).isFlammable((BlockGetter)this.level(), eastPos, Direction.WEST);
            boolean south = this.level().getBlockState(southPos).isFlammable((BlockGetter)this.level(), southPos, Direction.NORTH);
            boolean west = this.level().getBlockState(westPos).isFlammable((BlockGetter)this.level(), westPos, Direction.EAST);
            fire = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)fire.setValue((Property)FireBlock.UP, (Comparable)Boolean.valueOf(up))).setValue((Property)FireBlock.NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)FireBlock.EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)FireBlock.SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)FireBlock.WEST, (Comparable)Boolean.valueOf(west));
        }
        this.level().setBlock(pos, fire, 3);
    }
}

