/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.datastorage.reservoir;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.RegionPos;
import flaxbeard.immersivepetroleum.common.datastorage.reservoir.ReservoirRegionDataStorage;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionData
extends SavedData {
    protected static final Logger log = LogManager.getLogger((String)"immersivepetroleum/RegionData");
    final RegionPos regionPos;
    final Multimap<ResourceKey<Level>, Reservoir> reservoirlist = ArrayListMultimap.create();

    RegionData(RegionPos regionPos) {
        this.regionPos = regionPos;
    }

    RegionData(RegionPos regionPos, CompoundTag nbt, HolderLookup.Provider provider) {
        this.regionPos = regionPos;
        this.load(nbt, provider);
    }

    public void save(File pFile, @Nonnull HolderLookup.Provider provider) {
        if (!pFile.getParentFile().exists()) {
            pFile.getParentFile().mkdirs();
        }
        super.save(pFile, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag nbt, @Nonnull HolderLookup.Provider provider) {
        nbt.putInt("version", 2);
        ListTag reservoirs = new ListTag();
        Multimap<ResourceKey<Level>, Reservoir> multimap = this.reservoirlist;
        synchronized (multimap) {
            for (ResourceKey dimension : this.reservoirlist.keySet()) {
                CompoundTag dim = new CompoundTag();
                dim.putString("dimension", dimension.location().toString());
                ListTag islands = new ListTag();
                for (Reservoir reservoir : this.reservoirlist.get((Object)dimension)) {
                    islands.add((Object)reservoir.writeToNBT());
                }
                dim.put("islands", (Tag)islands);
                reservoirs.add((Object)dim);
            }
        }
        nbt.put("reservoirs", (Tag)reservoirs);
        ReservoirRegionDataStorage.log.debug("{} Saved with {} Reservoirs.", (Object)this, (Object)this.reservoirlist.size());
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag reservoirs;
        int version = nbt.getInt("version");
        if (version != 2) {
            // empty if block
        }
        if (!(reservoirs = nbt.getList("reservoirs", 10)).isEmpty()) {
            Multimap<ResourceKey<Level>, Reservoir> multimap = this.reservoirlist;
            synchronized (multimap) {
                for (int i = 0; i < reservoirs.size(); ++i) {
                    CompoundTag dim = reservoirs.getCompound(i);
                    ResourceLocation rl = ResourceLocation.parse((String)dim.getString("dimension"));
                    ResourceKey dimType = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)rl);
                    ListTag islands = dim.getList("islands", 10);
                    List<Reservoir> list = islands.stream().map(inbt -> Reservoir.readFromNBT((CompoundTag)inbt)).filter(Objects::nonNull).collect(Collectors.toList());
                    list.forEach(reservoir -> reservoir.setRegion(this));
                    this.reservoirlist.putAll((Object)dimType, list);
                }
            }
            ReservoirRegionDataStorage.log.debug("{} Loaded with {} Reservoirs.", (Object)this, (Object)this.reservoirlist.size());
        }
    }

    public RegionPos position() {
        return this.regionPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Reservoir get(ResourceKey<Level> dimension, ColumnPos pos) {
        Multimap<ResourceKey<Level>, Reservoir> multimap = this.reservoirlist;
        synchronized (multimap) {
            for (Reservoir reservoir : this.reservoirlist.get(dimension)) {
                if (!reservoir.getPolygon().contains(pos)) continue;
                return reservoir;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multimap<ResourceKey<Level>, Reservoir> getReservoirList() {
        Multimap<ResourceKey<Level>, Reservoir> multimap = this.reservoirlist;
        synchronized (multimap) {
            return ImmutableMultimap.copyOf(this.reservoirlist);
        }
    }

    public int hashCode() {
        return Objects.hash(this.regionPos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegionData)) {
            return false;
        }
        RegionData other = (RegionData)((Object)obj);
        return Objects.equals(this.regionPos, other.regionPos);
    }

    public String toString() {
        return String.format("RegionData[%d, %d]", this.regionPos.x(), this.regionPos.z());
    }
}

