/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.cfg;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="immersivepetroleum", bus=EventBusSubscriber.Bus.MOD)
public class IPClientConfig {
    public static final Miscellaneous MISCELLANEOUS;
    public static final GridColors GRID_COLORS;
    public static final DerrickConsole DERRICK_CONSOLE;
    public static final ModConfigSpec ALL;

    private static boolean hexValidator(Logger log, Object obj, String cfgPath) {
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.length() > 6) {
                String strNew = str.substring(str.length() - 6);
                log.warn("{}: \"{}\" was cut down to \"{}\".", (Object)cfgPath, (Object)str, (Object)strNew);
                str = strNew;
            }
            if (str.length() == 6) {
                try {
                    Integer.valueOf(str, 16);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            log.error("{}: \"{}\" is not a valid RGB Hex color.", (Object)cfgPath, (Object)str);
        }
        return false;
    }

    @SubscribeEvent
    public static void onConfigChange(ModConfigEvent.Reloading ev) {
        VarCache.CACHES.forEach(VarCache::reset);
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        GRID_COLORS = new GridColors(builder);
        DERRICK_CONSOLE = new DerrickConsole(builder);
        MISCELLANEOUS = new Miscellaneous(builder);
        ALL = builder.build();
    }

    private static class VarCache<V> {
        private static final Set<VarCache<?>> CACHES = new HashSet();
        private final Supplier<V> supplier;
        private V value;

        private VarCache(Supplier<V> supplier) {
            this.supplier = supplier;
            CACHES.add(this);
        }

        public void reset() {
            this.value = null;
        }

        public V get() {
            if (this.value == null) {
                this.value = this.supplier.get();
            }
            return this.value;
        }
    }

    public static class GridColors {
        private static final Logger log = LogManager.getLogger((String)"immersivepetroleum/ClientConfig/GridColors");
        final VarCache<Integer> pipe_normal_color;
        final VarCache<Integer> pipe_perforated_color;
        final VarCache<Integer> pipe_perforated_fixed_color;

        GridColors(ModConfigSpec.Builder builder) {
            builder.push("GridColors");
            ModConfigSpec.ConfigValue pipe_normal_color = builder.comment(new String[]{"Normal pipe color. (Hex RGB)", "Default: A5A5A5"}).define("normal_pipe_color", (Object)"A5A5A5", o -> IPClientConfig.hexValidator(log, o, "normal_pipe_color"));
            this.pipe_normal_color = new VarCache<Integer>(() -> Integer.parseInt((String)pipe_normal_color.get(), 16));
            ModConfigSpec.ConfigValue pipe_perforated_color = builder.comment(new String[]{"Perforated pipe color. (Hex RGB)", "Default: 54FF54"}).define("perforated_pipe_color", (Object)"54FF54", o -> IPClientConfig.hexValidator(log, o, "perforated_pipe_color"));
            this.pipe_perforated_color = new VarCache<Integer>(() -> Integer.parseInt((String)pipe_perforated_color.get(), 16));
            ModConfigSpec.ConfigValue pipe_perforated_fixed_color = builder.comment(new String[]{"Perforated pipe color. (Hex RGB)", "Default: FF515A"}).define("fixed_perforated_pipe_color", (Object)"FF515A", o -> IPClientConfig.hexValidator(log, o, "fixed_perforated_pipe_color"));
            this.pipe_perforated_fixed_color = new VarCache<Integer>(() -> Integer.parseInt((String)pipe_perforated_fixed_color.get(), 16));
            builder.pop();
        }

        public int getPipeColorNormal() {
            return this.pipe_normal_color.get();
        }

        public int getPipeColorPerforated() {
            return this.pipe_perforated_color.get();
        }

        public int getPipeColorPerforatedFixed() {
            return this.pipe_perforated_fixed_color.get();
        }
    }

    public static class DerrickConsole {
        private static final Logger log = LogManager.getLogger((String)"immersivepetroleum/ClientConfig/DerrickConsole");
        final VarCache<Boolean> use_old_style;
        final VarCache<Integer> text_color_error;
        final VarCache<Integer> text_color_normal;

        DerrickConsole(ModConfigSpec.Builder builder) {
            builder.push("DerrickConsole");
            ModConfigSpec.BooleanValue use_old_style = builder.comment(new String[]{"Use the old text style.", "Default: false"}).define("old_school", false);
            this.use_old_style = new VarCache<Boolean>(() -> ((ModConfigSpec.BooleanValue)use_old_style).getAsBoolean());
            ModConfigSpec.ConfigValue text_color_normal = builder.comment(new String[]{"Normal Text Color. (Hex RGB)", "Default: FF9900"}).define("text_color_normal", (Object)"FF9900", o -> IPClientConfig.hexValidator(log, o, "text_color_normal"));
            this.text_color_normal = new VarCache<Integer>(() -> Integer.parseInt((String)text_color_normal.get(), 16));
            ModConfigSpec.ConfigValue text_color_error = builder.comment(new String[]{"Error Text Color. (Hex RGB)", "Default: EF0000"}).define("text_color_error", (Object)"EF0000", o -> IPClientConfig.hexValidator(log, o, "text_color_normal"));
            this.text_color_error = new VarCache<Integer>(() -> Integer.parseInt((String)text_color_error.get(), 16));
            builder.pop();
        }

        public boolean useOldSchool() {
            return this.use_old_style.get();
        }

        public int getTextColorNormal() {
            return this.text_color_normal.get();
        }

        public int getTextColorError() {
            return this.text_color_error.get();
        }
    }

    public static class Miscellaneous {
        private static final Logger log = LogManager.getLogger((String)"immersivepetroleum/ClientConfig/Miscellaneous");

        Miscellaneous(ModConfigSpec.Builder builder) {
            builder.push("Miscellaneous");
            builder.pop();
        }
    }
}

