/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.util.IESounds;
import flaxbeard.immersivepetroleum.api.reservoir.Reservoir;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.IPTileEntityBase;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.survey.ReservoirInfo;
import flaxbeard.immersivepetroleum.common.util.survey.SurveyScan;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SeismicSurveyTileEntity
extends IPTileEntityBase
implements IPCommonTickableTile {
    public static final int DELAY = 10;
    public int timer = 0;
    @Nonnull
    public ItemStack stack = ItemStack.EMPTY;
    public boolean isSlave;

    public SeismicSurveyTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)IPTileTypes.SEISMIC_SURVEY.get(), pWorldPosition, pBlockState);
    }

    @Override
    protected void writeCustom(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putBoolean("slave", this.isSlave);
        tag.putInt("timer", this.timer);
        tag.put("stack", this.stack.saveOptional(provider));
    }

    @Override
    protected void readCustom(CompoundTag tag, HolderLookup.Provider provider) {
        this.isSlave = tag.getBoolean("slave");
        this.timer = tag.getInt("timer");
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("stack"));
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        if (this.timer > 0) {
            --this.timer;
            this.setChanged();
        }
    }

    public SeismicSurveyTileEntity master() {
        if (this.isSlave) {
            for (int i = 1; i < 3; ++i) {
                BlockEntity te = this.level.getBlockEntity(this.getBlockPos().offset(0, -i, 0));
                if (!(te instanceof SeismicSurveyTileEntity)) continue;
                SeismicSurveyTileEntity seis = (SeismicSurveyTileEntity)te;
                if (seis.isSlave) continue;
                return seis;
            }
        }
        return this;
    }

    public boolean interact(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        if (this.timer > 0) {
            return false;
        }
        ItemStack held = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (player.isShiftKeyDown() && !this.stack.isEmpty()) {
            if (!world.isClientSide) {
                Utils.dropItemNoDelay(world, player.blockPosition().above(), this.stack);
                this.stack = ItemStack.EMPTY;
                this.setChanged();
            }
            return true;
        }
        if (held.isEmpty()) {
            boolean fire = false;
            if (!this.stack.isEmpty()) {
                if (ExternalModContent.IE.isBuckshot(this.stack)) {
                    fire = true;
                    if (!world.isClientSide) {
                        this.timer = 10;
                        this.stack = new ItemStack((ItemLike)ExternalModContent.IE.itemEmptyShell());
                        this.setChanged();
                    }
                } else {
                    if (!world.isClientSide) {
                        Utils.dropItemNoDelay(world, player.blockPosition().above(), this.stack);
                        this.stack = ItemStack.EMPTY;
                        this.setChanged();
                        double bX = (double)pos.getX() + 0.5;
                        double bY = (double)pos.getY() + 0.5;
                        double bZ = (double)pos.getZ() + 0.5;
                        world.playSound(null, bX, bY, bZ, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 0.25f);
                        world.playSound(null, bX, bY, bZ, (Holder)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE, SoundSource.BLOCKS, 0.25f, 0.1f);
                    }
                    return true;
                }
            }
            if (fire) {
                if (world.isClientSide) {
                    double dst;
                    if (!player.isCreative() && (dst = Math.sqrt(player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5))) < 4.0) {
                        double scale = 1.0 - Mth.clamp((double)(dst / 3.0), (double)0.0, (double)1.0);
                        player.animateHurt(Math.random() < 0.5 ? 180.0f : 0.0f);
                        player.hurtDuration = 40;
                        player.hurtTime = 40 + (int)(30.0 * scale);
                    }
                    double bX = (double)pos.getX() + 0.5;
                    double bY = (double)pos.getY() + 0.25;
                    double bZ = (double)pos.getZ() + 0.5;
                    double hSpeed = 0.05;
                    for (float i = 0.0f; i < 360.0f; i += 11.25f) {
                        double xa = Math.sin(Math.toRadians(i));
                        double za = Math.cos(Math.toRadians(i));
                        world.addParticle((ParticleOptions)(Math.random() < 0.5 ? ParticleTypes.SMOKE : ParticleTypes.LARGE_SMOKE), bX + (xa *= 0.75), bY, bZ + (za *= 0.75), hSpeed * xa, 0.0, hSpeed * za);
                    }
                } else {
                    SoundEvent sound = ((BulletItem)ExternalModContent.IE.itemBuckshot()).getType().getSound();
                    if (sound == null) {
                        sound = (SoundEvent)IESounds.revolverFire.value();
                    }
                    double bX = (double)pos.getX() + 0.5;
                    double bY = (double)pos.getY() + 0.5;
                    double bZ = (double)pos.getZ() + 0.5;
                    double dst = Math.sqrt(player.distanceToSqr(bX, bY, bZ));
                    float volume = (float)(1.0 - Mth.clamp((double)(dst / 3.0), (double)0.0, (double)0.85));
                    world.playSound(null, bX, bY, bZ, sound, SoundSource.BLOCKS, volume, 0.5f);
                }
                if (!world.isClientSide) {
                    Record info;
                    Reservoir currentIsland = ReservoirHandler.getReservoirNoCache(world, pos);
                    ItemStack stack = new ItemStack((ItemLike)IPContent.Items.SURVEYRESULT.get());
                    if (currentIsland != null) {
                        info = ReservoirInfo.create(world, pos, currentIsland);
                        if (((ReservoirInfo)info).getFluid().equals(IPContent.Fluids.CRUDEOIL.get())) {
                            Utils.unlockIPAdvancement(player, "main/root");
                        }
                    } else {
                        info = SurveyScan.create(world, pos);
                    }
                    info.writeToStack(stack);
                    Utils.dropItemNoDelay(world, player.blockPosition().above(), stack);
                }
                return true;
            }
            return false;
        }
        if (ExternalModContent.IE.isBuckshot(held) && this.stack.isEmpty()) {
            if (!world.isClientSide) {
                ItemStack copy = held.copy();
                copy.setCount(1);
                this.stack = copy;
                if (!player.isCreative()) {
                    held.shrink(1);
                    if (held.isEmpty()) {
                        player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    }
                }
                this.setChanged();
            }
            return true;
        }
        return false;
    }

    public void setChanged() {
        super.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        this.level.updateNeighborsAt(this.worldPosition, state.getBlock());
    }
}

