/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import flaxbeard.immersivepetroleum.api.crafting.FlarestackHandler;
import flaxbeard.immersivepetroleum.client.particle.IPParticleTypes;
import flaxbeard.immersivepetroleum.common.IPCapabilityRegistry;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.IPTileEntityBase;
import flaxbeard.immersivepetroleum.common.sound.IPSounds;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.damageSources.IPDamageSources;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FlarestackTileEntity
extends IPTileEntityBase
implements IPCommonTickableTile,
IPCapabilityRegistry.IHasCapability,
IEBlockInterfaces.ISoundBE {
    protected boolean isRedstoneInverted;
    protected boolean isActive;
    protected short drained;
    protected final FluidTank tank = new FluidTank(250, fs -> fs != FluidStack.EMPTY && FlarestackHandler.isBurnable(fs));

    public FlarestackTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)IPTileTypes.FLARE.get(), pWorldPosition, pBlockState);
    }

    public void invertRedstone() {
        this.isRedstoneInverted = !this.isRedstoneInverted;
        this.setChanged();
    }

    public boolean isRedstoneInverted() {
        return this.isRedstoneInverted;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public short getFlow() {
        return this.drained;
    }

    @Override
    public void readCustom(CompoundTag nbt, HolderLookup.Provider provider) {
        this.isRedstoneInverted = nbt.getBoolean("inverted");
        this.isActive = nbt.getBoolean("active");
        this.drained = nbt.getShort("drained");
        this.tank.readFromNBT(provider, nbt.getCompound("tank"));
    }

    @Override
    public void writeCustom(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putBoolean("inverted", this.isRedstoneInverted);
        nbt.putBoolean("active", this.isActive);
        nbt.putShort("drained", this.drained);
        CompoundTag tank = this.tank.writeToNBT(provider, new CompoundTag());
        nbt.put("tank", (Tag)tank);
    }

    @Override
    public <T> T getCapability(Direction side) {
        if (side == null || side == Direction.DOWN) {
            return (T)this.tank;
        }
        return null;
    }

    public void setChanged() {
        super.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        this.level.updateNeighborsAt(this.worldPosition, state.getBlock());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.getBlockPos();
        return AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 2, 1));
    }

    @Override
    public void tickClient() {
        ImmersiveEngineering.proxy.handleTileSound(IPSounds.FLARESTACK, (BlockEntity)this, this.isActive, 1.0f, 0.75f);
        if (this.isActive) {
            if (this.level.getGameTime() % 2L == 0L) {
                float xPos = (float)this.worldPosition.getX() + 0.5f + (this.level.random.nextFloat() - 0.5f) * 0.4375f;
                float zPos = (float)this.worldPosition.getZ() + 0.5f + (this.level.random.nextFloat() - 0.5f) * 0.4375f;
                float yPos = (float)this.worldPosition.getY() + 1.875f + 0.2f * this.level.random.nextFloat();
                this.level.addParticle((ParticleOptions)IPParticleTypes.FLARE_FIRE.get(), (double)xPos, (double)yPos, (double)zPos, 0.0, (double)(0.0625f + (float)this.drained / (float)this.tank.getCapacity() * 0.125f), 0.0);
            }
        } else if (this.level.getGameTime() % 5L == 0L) {
            float xPos = (float)this.worldPosition.getX() + 0.5f + (this.level.random.nextFloat() - 0.5f) * 0.4375f;
            float zPos = (float)this.worldPosition.getZ() + 0.5f + (this.level.random.nextFloat() - 0.5f) * 0.4375f;
            float yPos = (float)this.worldPosition.getY() + 1.6f;
            float xa = (this.level.random.nextFloat() - 0.5f) * 0.00625f;
            float ya = (this.level.random.nextFloat() - 0.5f) * 0.00625f;
            this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)xPos, (double)yPos, (double)zPos, (double)xa, (double)0.025f, (double)ya);
        }
    }

    @Override
    public void tickServer() {
        List list;
        boolean lastActive = this.isActive;
        this.isActive = false;
        int redstone = this.level.getBestNeighborSignal(this.worldPosition);
        if (this.isRedstoneInverted()) {
            redstone = 15 - redstone;
        }
        if (redstone > 0 && this.tank.getFluidAmount() > 0) {
            float signal = (float)redstone / 15.0f;
            FluidStack fs = this.tank.drain((int)((float)this.tank.getCapacity() * signal), IFluidHandler.FluidAction.SIMULATE);
            if (fs.getAmount() > 0) {
                this.tank.drain(fs.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                this.drained = (short)fs.getAmount();
                this.isActive = true;
            }
        }
        if (this.isActive && this.level.getGameTime() % 10L == 0L && !(list = this.getLevel().getEntitiesOfClass(Entity.class, new AABB(this.worldPosition).inflate(1.0))).isEmpty()) {
            list.forEach(e -> {
                if (!e.fireImmune()) {
                    e.igniteForTicks(15);
                    e.hurt(IPDamageSources.flarestack(this.level), 6.0f * ((float)this.drained / (float)this.tank.getCapacity()));
                }
            });
            List<Entity> goats = list.stream().filter(e -> e instanceof Goat).toList();
            if (!goats.isEmpty()) {
                List players = this.getLevel().getEntitiesOfClass(Player.class, new AABB(this.worldPosition).inflate(8.0));
                for (Entity g : goats) {
                    if (g.isAlive()) continue;
                    players.forEach(p -> Utils.unlockIPAdvancement(p, "main/flarestack"));
                    break;
                }
            }
        }
        if (lastActive != this.isActive || !this.level.isClientSide && this.isActive) {
            this.setChanged();
        }
    }

    public boolean shouldPlaySound(@Nonnull String sound) {
        return true;
    }
}

