/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.hydro_treater;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import flaxbeard.immersivepetroleum.api.crafting.HighPressureRefineryRecipe;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.IReadWriteNBT;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.hydro_treater.HydroTreaterProcess;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.shapes.HydroTreaterShape;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import flaxbeard.immersivepetroleum.common.util.inventory.FluidTankFiltered;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class HydroTreaterLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int TANK_INPUT_A = 0;
    public static final int TANK_INPUT_B = 1;
    public static final int TANK_OUTPUT = 2;
    public static final CapabilityPosition Fluid_IN_A = new CapabilityPosition(1, 0, 3, RelativeBlockFace.BACK);
    public static final CapabilityPosition Fluid_IN_B = new CapabilityPosition(2, 2, 1, RelativeBlockFace.UP);
    public static final MultiblockFace FLUID_OUT = new MultiblockFace(0, 1, 2, RelativeBlockFace.UP);
    public static final CapabilityPosition Fluid_OUT = new CapabilityPosition(0, 1, 2, RelativeBlockFace.UP);
    public static final BlockPos Item_OUT = new BlockPos(0, 0, 2);
    public static final CapabilityPosition Energy_IN = new CapabilityPosition(2, 2, 3, RelativeBlockFace.UP);
    public static final BlockPos Redstone_IN = new BlockPos(0, 1, 3);

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        if (state.cooldownTicks > 0) {
            --state.cooldownTicks;
        }
        if (state.wasActive) {
            state.cooldownTicks = 20;
        }
    }

    public void tickServer(IMultiblockContext<State> context) {
        RecipeHolder<HighPressureRefineryRecipe> holder;
        boolean update = false;
        State state = (State)context.getState();
        Level level = context.getLevel().getRawLevel();
        if (state.wasActive) {
            state.wasActive = false;
            update = true;
        }
        if (state.rsState.isEnabled(context) && state.energy.getEnergyStored() > 0 && state.processor.getQueueSize() < state.processor.getMaxQueueSize() && (state.tanks.primary().getFluidAmount() > 0 || state.tanks.secondary().getFluidAmount() > 0) && (holder = HighPressureRefineryRecipe.findRecipe(state.tanks.primary().getFluid(), state.tanks.secondary().getFluid())) != null) {
            HighPressureRefineryRecipe recipe = (HighPressureRefineryRecipe)holder.value();
            if (state.energy.getEnergyStored() >= recipe.getTotalProcessEnergy() / recipe.getTotalProcessTime() && state.tanks.primary().getFluidAmount() >= recipe.getPrimaryInputFluid().amount() && (recipe.getSecondaryInputFluid() == null || state.tanks.secondary().getFluidAmount() >= recipe.getSecondaryInputFluid().amount())) {
                int[] inputAmounts;
                int[] inputTanks;
                if (recipe.getSecondaryInputFluid() != null) {
                    inputTanks = new int[]{0, 1};
                    inputAmounts = new int[]{recipe.getPrimaryInputFluid().amount(), recipe.getSecondaryInputFluid().amount()};
                } else {
                    inputTanks = new int[]{0};
                    inputAmounts = new int[]{recipe.getPrimaryInputFluid().amount()};
                }
                HydroTreaterProcess process = new HydroTreaterProcess(holder, inputTanks, inputAmounts);
                if (state.processor.addProcessToQueue((MultiblockProcess)process, level, true)) {
                    state.processor.addProcessToQueue((MultiblockProcess)process, level, false);
                    update = true;
                }
            }
        }
        if (state.processor.tickServer((ProcessContext)state, context.getLevel(), !state.processor.getQueue().isEmpty())) {
            update = true;
            state.wasActive = true;
        }
        if (state.tanks.output().getFluidAmount() > 0) {
            BlockPos outPos = context.getLevel().toAbsolute(Fluid_OUT.posInMultiblock()).above();
            update |= FluidUtil.getFluidHandler((Level)level, (BlockPos)outPos, (Direction)Direction.DOWN).map(output -> {
                boolean ret = false;
                FluidStack target = state.tanks.output().getFluid();
                int accepted = output.fill(target = FluidHelper.copyFluid(target, Math.min(target.getAmount(), 1000)), IFluidHandler.FluidAction.SIMULATE);
                if (accepted > 0) {
                    int drained = output.fill(FluidHelper.copyFluid(target, Math.min(target.getAmount(), accepted)), IFluidHandler.FluidAction.EXECUTE);
                    state.tanks.output().drain(new FluidStack(target.getFluid(), drained), IFluidHandler.FluidAction.EXECUTE);
                    ret = true;
                }
                return ret;
            }).orElse(false).booleanValue();
        }
        if (update) {
            context.markDirtyAndSync();
        }
    }

    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, Energy_IN, state -> state.energy);
        register.register(Capabilities.FluidHandler.BLOCK, (state, pos) -> {
            if (Fluid_IN_A.equalsOrNullFace(pos)) {
                return state.fluidInputMain;
            }
            if (Fluid_IN_B.equalsOrNullFace(pos)) {
                return state.fluidInputSecondary;
            }
            if (Fluid_OUT.equalsOrNullFace(pos)) {
                return state.fluidOutput;
            }
            return null;
        });
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return HydroTreaterShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<HighPressureRefineryRecipe> {
        public static final int ENERGY_STORAGE_CAPACITY = 8000;
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(8000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final Tanks tanks = Tanks.server();
        public final MultiblockProcessor.InMachineProcessor<HighPressureRefineryRecipe> processor;
        private final IFluidHandler fluidInputMain;
        private final IFluidHandler fluidInputSecondary;
        private final IFluidHandler fluidOutput;
        private final IFluidHandler outputRef;
        public int cooldownTicks = 0;
        public boolean wasActive = false;

        public State(IInitialMultiblockContext<State> context) {
            this.processor = new MultiblockProcessor.InMachineProcessor(1, 0.0f, 1, context.getMarkDirtyRunnable(), State::getRecipeForId);
            this.outputRef = (IFluidHandler)context.getCapabilityAt(Capabilities.FluidHandler.BLOCK, FLUID_OUT).get();
            this.fluidInputMain = ArrayFluidHandler.fillOnly((IFluidTank)this.tanks.primary(), (Runnable)context.getMarkDirtyRunnable());
            this.fluidInputSecondary = ArrayFluidHandler.fillOnly((IFluidTank)this.tanks.secondary(), (Runnable)context.getMarkDirtyRunnable());
            this.fluidOutput = ArrayFluidHandler.drainOnly((IFluidTank)this.tanks.output(), (Runnable)context.getMarkDirtyRunnable());
        }

        private static HighPressureRefineryRecipe getRecipeForId(Level level, ResourceLocation id) {
            return (HighPressureRefineryRecipe)HighPressureRefineryRecipe.recipes.get(id).value();
        }

        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("tanks", (Tag)this.tanks.writeNBT(provider));
            nbt.put("energy", this.energy.serializeNBT(provider));
            nbt.put("processor", this.processor.toNBT(provider));
            this.rsState.writeSaveNBT(nbt, provider);
            nbt.putBoolean("wasActive", this.wasActive);
        }

        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.tanks.readNBT(nbt.getCompound("tanks"), provider);
            this.energy.deserializeNBT(provider, (Tag)nbt.getCompound("energy"));
            this.processor.fromNBT(nbt.get("processor"), HydroTreaterProcess::new, provider);
            this.rsState.readSaveNBT(nbt, provider);
            this.wasActive = nbt.getBoolean("wasActive");
        }

        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.writeSaveNBT(nbt, provider);
        }

        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.readSaveNBT(nbt, provider);
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public IFluidTank[] getInternalTanks() {
            return this.tanks.array();
        }

        public int[] getOutputTanks() {
            return new int[]{2};
        }

        public boolean additionalCanProcessCheck(MultiblockProcess<HighPressureRefineryRecipe, ?> process, Level level) {
            int outputAmount = 0;
            for (FluidStack outputFluid : ((HighPressureRefineryRecipe)process.getRecipe(level)).getFluidOutputs()) {
                outputAmount += outputFluid.getAmount();
            }
            return this.tanks.output().getCapacity() >= this.tanks.output().getFluidAmount() + outputAmount;
        }
    }

    public static class Tanks
    implements IReadWriteNBT {
        public static final int CAPACITY = 12000;
        private final FluidTankFiltered primary;
        private final FluidTankFiltered secondary;
        private final FluidTankFiltered output;
        private final IFluidTank[] array;

        public static Tanks server() {
            return new Tanks(new FluidTankFiltered(12000, fluidStack -> HighPressureRefineryRecipe.hasRecipeWithInput(fluidStack, true)), new FluidTankFiltered(12000, fluidStack -> HighPressureRefineryRecipe.hasRecipeWithSecondaryInput(fluidStack, true)), new FluidTankFiltered(12000));
        }

        public static Tanks client() {
            return new Tanks(new FluidTankFiltered(12000), new FluidTankFiltered(12000), new FluidTankFiltered(12000));
        }

        private Tanks(FluidTankFiltered primary, FluidTankFiltered secondary, FluidTankFiltered output) {
            this.primary = primary;
            this.secondary = secondary;
            this.output = output;
            this.array = new IFluidTank[]{primary, secondary, output};
        }

        @Override
        public void readNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.primary.readFromNBT(nbt.getCompound("primary"), provider);
            this.secondary.readFromNBT(nbt.getCompound("secondary"), provider);
            this.output.readFromNBT(nbt.getCompound("output"), provider);
        }

        @Override
        public CompoundTag writeNBT(HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("primary", (Tag)this.primary.writeToNBT(new CompoundTag(), provider));
            nbt.put("secondary", (Tag)this.secondary.writeToNBT(new CompoundTag(), provider));
            nbt.put("output", (Tag)this.output.writeToNBT(new CompoundTag(), provider));
            return nbt;
        }

        public FluidTankFiltered primary() {
            return this.primary;
        }

        public FluidTankFiltered secondary() {
            return this.secondary;
        }

        public FluidTankFiltered output() {
            return this.output;
        }

        public IFluidTank[] array() {
            return this.array;
        }
    }
}

