/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.distillation_tower;

import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import flaxbeard.immersivepetroleum.api.crafting.DistillationTowerRecipe;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.IReadWriteNBT;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.distillation_tower.DistillationTowerProcess;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.shapes.DistillationTowerShape;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import flaxbeard.immersivepetroleum.common.util.inventory.EnumInventory;
import flaxbeard.immersivepetroleum.common.util.inventory.FluidTankFiltered;
import flaxbeard.immersivepetroleum.common.util.inventory.MultiFluidTankFiltered;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class DistillationTowerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    public static final CapabilityPosition Fluid_IN = new CapabilityPosition(3, 0, 3, RelativeBlockFace.LEFT);
    public static final CapabilityPosition Fluid_OUT = new CapabilityPosition(1, 0, 3, RelativeBlockFace.BACK);
    public static final BlockPos Item_OUT = new BlockPos(0, 0, 1);
    public static final CapabilityPosition ENERGY_IN = new CapabilityPosition(3, 1, 3, RelativeBlockFace.UP);
    public static final BlockPos REDSTONE_IN = new BlockPos(0, 1, 3);

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public void tickClient(IMultiblockContext<State> context) {
        State state = (State)context.getState();
        if (state.cooldownTicks > 0) {
            --state.cooldownTicks;
        }
        if (state.wasActive) {
            state.cooldownTicks = 20;
        }
    }

    public void tickServer(IMultiblockContext<State> context) {
        ItemStack emptyContainer;
        ItemStack inputEmpty;
        State state = (State)context.getState();
        Level level = context.getLevel().getRawLevel();
        boolean rsEnabled = state.rsState.isEnabled(context);
        boolean update = false;
        if (state.wasActive) {
            state.wasActive = false;
            update = true;
        }
        if (rsEnabled) {
            RecipeHolder<DistillationTowerRecipe> holder;
            if (state.energy.getEnergyStored() > 0 && state.processor.getQueueSize() < state.processor.getMaxQueueSize() && state.tanks.input().getFluidAmount() > 0 && (holder = DistillationTowerRecipe.findRecipe(state.tanks.input().getFluid())) != null) {
                DistillationTowerProcess process;
                DistillationTowerRecipe recipe = (DistillationTowerRecipe)holder.value();
                if (state.tanks.input().getFluidAmount() >= recipe.getInputFluid().amount() && state.energy.getEnergyStored() >= recipe.getTotalProcessEnergy() / recipe.getTotalProcessTime() && state.processor.addProcessToQueue((MultiblockProcess)(process = new DistillationTowerProcess(holder)), level, true)) {
                    state.processor.addProcessToQueue((MultiblockProcess)process, level, false);
                    update = true;
                }
            }
            if (state.processor.tickServer((ProcessContext)state, context.getLevel(), !state.processor.getQueue().isEmpty())) {
                state.wasActive = true;
                update = true;
            }
        }
        if (!state.inventory.get(Inventory.INPUT_FILLED).isEmpty() && state.tanks.input().getFluidAmount() < state.tanks.input().getCapacity() && (inputEmpty = state.inventory.get(Inventory.INPUT_EMPTY)).getCount() < inputEmpty.getMaxStackSize() && !(emptyContainer = FluidHelper.tryDrainContainer(state.inventory.get(Inventory.INPUT_FILLED), state.tanks.input())).isEmpty()) {
            if (!inputEmpty.isEmpty() && inputEmpty.isStackable() && inputEmpty.getCount() < inputEmpty.getMaxStackSize()) {
                inputEmpty.grow(emptyContainer.getCount());
            } else if (inputEmpty.isEmpty()) {
                state.inventory.set(Inventory.INPUT_EMPTY, emptyContainer.copy());
            }
            state.inventory.get(Inventory.INPUT_FILLED).shrink(1);
            if (state.inventory.get(Inventory.INPUT_FILLED).getCount() <= 0) {
                state.inventory.set(Inventory.INPUT_FILLED, ItemStack.EMPTY);
            }
            update = true;
        }
        if (state.tanks.output().getFluidAmount() > 0) {
            MultiFluidTankFiltered outTank = state.tanks.output();
            if (state.inventory.get(Inventory.OUTPUT_EMPTY) != ItemStack.EMPTY && outTank.getTanks() > 0) {
                for (int i = outTank.getTanks() - 1; i >= 0; --i) {
                    ItemStack filledContainer;
                    FluidStack fs = outTank.getFluidInTank(i);
                    if (fs.getAmount() <= 0 || (filledContainer = FluidHelper.fillFluidContainer(outTank, fs, state.inventory.get(Inventory.OUTPUT_EMPTY), state.inventory.get(Inventory.OUTPUT_FILLED))).isEmpty()) continue;
                    ItemStack inv_3_stack = state.inventory.get(Inventory.OUTPUT_FILLED);
                    if (inv_3_stack.getCount() == 1 && !FluidHelper.isFluidContainerFull(filledContainer)) {
                        state.inventory.set(Inventory.OUTPUT_FILLED, filledContainer.copy());
                    } else {
                        if (!inv_3_stack.isEmpty() && inv_3_stack.isStackable() && inv_3_stack.getCount() < inv_3_stack.getMaxStackSize()) {
                            inv_3_stack.grow(filledContainer.getCount());
                        } else if (inv_3_stack.isEmpty()) {
                            state.inventory.set(Inventory.OUTPUT_FILLED, filledContainer.copy());
                        }
                        state.inventory.get(Inventory.OUTPUT_EMPTY).shrink(1);
                        if (state.inventory.get(Inventory.OUTPUT_EMPTY).getCount() <= 0) {
                            state.inventory.set(Inventory.OUTPUT_EMPTY, ItemStack.EMPTY);
                        }
                    }
                    update = true;
                    break;
                }
            }
            MultiblockOrientation orientation = context.getLevel().getOrientation();
            BlockPos outPos = context.getLevel().toAbsolute(Fluid_OUT.posInMultiblock()).relative(orientation.front().getOpposite());
            update |= FluidUtil.getFluidHandler((Level)level, (BlockPos)outPos, (Direction)orientation.front()).map(output -> {
                boolean ret = false;
                if (!state.tanks.input().getFluid().isEmpty()) {
                    ArrayList<FluidStack> toDrain = new ArrayList<FluidStack>();
                    boolean iePipe = level.getBlockEntity(outPos) instanceof IFluidPipe;
                    for (int i = 0; i < outTank.getTanks(); ++i) {
                        FluidStack target = outTank.getFluidInTank(i);
                        FluidStack outStack = FluidHelper.copyFluid(target, Math.min(target.getAmount(), 100), iePipe);
                        int accepted = output.fill(outStack, IFluidHandler.FluidAction.SIMULATE);
                        if (accepted <= 0) continue;
                        int drained = output.fill(FluidHelper.copyFluid(outStack, Math.min(outStack.getAmount(), accepted), iePipe), IFluidHandler.FluidAction.EXECUTE);
                        toDrain.add(new FluidStack(target.getFluid(), drained));
                        ret = true;
                    }
                    toDrain.forEach(fluid -> outTank.drain((FluidStack)fluid, IFluidHandler.FluidAction.EXECUTE));
                }
                return ret;
            }).orElse(false).booleanValue();
        }
        if (update) {
            context.markDirtyAndSync();
        }
    }

    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_IN, state -> state.energy);
        register.register(Capabilities.FluidHandler.BLOCK, (state, pos) -> {
            if (Fluid_IN.equalsOrNullFace(pos)) {
                return state.fluidInput;
            }
            if (Fluid_OUT.equalsOrNullFace(pos)) {
                return state.fluidOutput;
            }
            return null;
        });
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return DistillationTowerShape.GETTER;
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<DistillationTowerRecipe> {
        public static final int ENERGY_STORAGE_CAPACITY = 16000;
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public final MultiblockProcessor.InMachineProcessor<DistillationTowerRecipe> processor;
        public final EnumInventory<Inventory> inventory = new EnumInventory<Inventory>(Inventory.class);
        public final Tanks tanks = Tanks.server();
        public int cooldownTicks = 0;
        public boolean wasActive = false;
        private final IFluidHandler fluidInput;
        private final IFluidHandler fluidOutput;

        public State(IInitialMultiblockContext<State> context) {
            this.processor = new MultiblockProcessor.InMachineProcessor(1, 0.0f, 1, context.getMarkDirtyRunnable(), State::recipeFromId);
            this.fluidInput = ArrayFluidHandler.fillOnly((IFluidTank)this.tanks.input(), (Runnable)context.getMarkDirtyRunnable());
            this.fluidOutput = ArrayFluidHandler.drainOnly((IFluidTank)this.tanks.output(), (Runnable)context.getMarkDirtyRunnable());
        }

        private static DistillationTowerRecipe recipeFromId(Level level, ResourceLocation id) {
            return (DistillationTowerRecipe)DistillationTowerRecipe.recipes.get(id).value();
        }

        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public IFluidTank[] getInternalTanks() {
            return this.tanks.array();
        }

        public int[] getOutputTanks() {
            return new int[]{1};
        }

        public boolean additionalCanProcessCheck(MultiblockProcess<DistillationTowerRecipe, ?> process, Level level) {
            int outputAmount = 0;
            for (FluidStack outputFluid : ((DistillationTowerRecipe)process.getRecipe(level)).getFluidOutputs()) {
                outputAmount += outputFluid.getAmount();
            }
            return this.tanks.output().getCapacity() >= this.tanks.output().getFluidAmount() + outputAmount;
        }

        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.tanks.readNBT(nbt.getCompound("tanks"), provider);
            this.energy.deserializeNBT(provider, (Tag)nbt.getCompound("energy"));
            this.processor.fromNBT((Tag)nbt.getCompound("recipeworker"), DistillationTowerProcess::new, provider);
            this.inventory.load(nbt, provider);
            this.rsState.readSaveNBT(nbt, provider);
            this.wasActive = nbt.getBoolean("wasActive");
        }

        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("tanks", (Tag)this.tanks.writeNBT(provider));
            nbt.put("energy", this.energy.serializeNBT(provider));
            nbt.put("recipeworker", this.processor.toNBT(provider));
            this.inventory.save(nbt, provider);
            this.rsState.writeSaveNBT(nbt, provider);
            nbt.putBoolean("wasActive", this.wasActive);
        }

        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.readSaveNBT(nbt, provider);
        }

        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.writeSaveNBT(nbt, provider);
        }
    }

    public static final class Tanks
    implements IReadWriteNBT {
        public static final int CAPACITY = 24000;
        private final FluidTankFiltered input;
        private final MultiFluidTankFiltered output;
        private final IFluidTank[] array;

        public static Tanks server() {
            return new Tanks(new FluidTankFiltered(24000, fs -> DistillationTowerRecipe.findRecipe(fs) != null), new MultiFluidTankFiltered(24000));
        }

        public static Tanks client() {
            return new Tanks(new FluidTankFiltered(24000), new MultiFluidTankFiltered(24000));
        }

        private Tanks(FluidTankFiltered input, MultiFluidTankFiltered output) {
            this.input = input;
            this.output = output;
            this.array = new IFluidTank[]{input, output};
        }

        @Override
        public void readNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.input.readFromNBT(nbt.getCompound("input"), provider);
            this.output.readFromNBT(nbt.getCompound("output"), provider);
        }

        @Override
        public CompoundTag writeNBT(HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            nbt.put("input", (Tag)this.input.writeToNBT(new CompoundTag(), provider));
            nbt.put("output", (Tag)this.output.writeToNBT(new CompoundTag(), provider));
            return nbt;
        }

        public FluidTankFiltered input() {
            return this.input;
        }

        public MultiFluidTankFiltered output() {
            return this.output;
        }

        public IFluidTank[] array() {
            return this.array;
        }
    }

    public static enum Inventory {
        INPUT_FILLED,
        INPUT_EMPTY,
        OUTPUT_EMPTY,
        OUTPUT_FILLED;


        public int id() {
            return this.ordinal();
        }

        public static int size() {
            return Inventory.values().length;
        }
    }
}

