/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.coker;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic.coker.CokerUnitLogic;
import flaxbeard.immersivepetroleum.common.util.inventory.FluidTankFiltered;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class CokingChamber {
    @Nullable
    protected RecipeHolder<CokerUnitRecipe> rHolder = null;
    protected State state = State.STANDBY;
    protected FluidTankFiltered tank;
    protected int capacity;
    protected int inputAmount = 0;
    protected int outputAmount = 0;
    protected int timer = 0;

    public CokingChamber(int itemCapacity, int fluidCapacity) {
        this.capacity = itemCapacity;
        this.tank = new FluidTankFiltered(fluidCapacity);
    }

    public CokingChamber readFromNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        this.tank.readFromNBT(nbt.getCompound("tank"), provider);
        this.timer = nbt.getInt("timer");
        this.inputAmount = nbt.getInt("input");
        this.outputAmount = nbt.getInt("output");
        this.state = State.values()[nbt.getInt("state")];
        if (nbt.contains("recipe", 8)) {
            try {
                ResourceLocation recipeName = ResourceLocation.parse((String)nbt.getString("recipe"));
                RecipeHolder<CokerUnitRecipe> recipe = CokerUnitRecipe.recipes.get(recipeName);
                if (recipe == null) {
                    ImmersivePetroleum.log.warn("Recipe {} is an unknown or removed recipe! Skipping...", (Object)recipeName);
                }
            }
            catch (ResourceLocationException e) {
                ImmersivePetroleum.log.error("Tried to load a coking recipe with an invalid name", (Throwable)e);
            }
        } else {
            this.rHolder = null;
        }
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.put("tank", (Tag)this.tank.writeToNBT(new CompoundTag(), provider));
        nbt.putInt("timer", this.timer);
        nbt.putInt("input", this.inputAmount);
        nbt.putInt("output", this.outputAmount);
        nbt.putInt("state", this.state.id());
        if (this.rHolder != null) {
            nbt.putString("recipe", this.rHolder.id().toString());
        }
        return nbt;
    }

    public boolean setRecipe(@Nullable RecipeHolder<CokerUnitRecipe> recipe) {
        if (this.state == State.STANDBY) {
            this.rHolder = recipe;
            return true;
        }
        return false;
    }

    public int addStack(@Nonnull ItemStack stack, boolean simulate) {
        if (this.rHolder != null && !stack.isEmpty() && ((CokerUnitRecipe)this.rHolder.value()).getInputItem().test(stack)) {
            int capacity = this.getCapacity() * ((CokerUnitRecipe)this.rHolder.value()).getInputItem().getCount();
            int current = this.getTotalAmount() * ((CokerUnitRecipe)this.rHolder.value()).getInputItem().getCount();
            if (simulate) {
                return Math.min(capacity - current, stack.getCount());
            }
            int filled = capacity - current;
            if (stack.getCount() < filled) {
                filled = stack.getCount();
            }
            ++this.inputAmount;
            return filled;
        }
        return 0;
    }

    public State getState() {
        return this.state;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getInputAmount() {
        return this.inputAmount;
    }

    public int getOutputAmount() {
        return this.outputAmount;
    }

    public int getTotalAmount() {
        return this.getInputAmount() + this.getOutputAmount();
    }

    public int getTimer() {
        return this.timer;
    }

    private boolean setStage(State state) {
        if (this.state != state) {
            this.state = state;
            return true;
        }
        return false;
    }

    @Nullable
    public RecipeHolder<CokerUnitRecipe> getRecipe() {
        return this.rHolder;
    }

    public ItemStack getInputItem() {
        if (this.rHolder == null) {
            return ItemStack.EMPTY;
        }
        return ((CokerUnitRecipe)this.rHolder.value()).getInputItem().getMatchingStacks()[0];
    }

    public ItemStack getOutputItem() {
        if (this.rHolder == null) {
            return ItemStack.EMPTY;
        }
        return ((CokerUnitRecipe)this.rHolder.value()).getOutputItem();
    }

    public FluidTankFiltered getTank() {
        return this.tank;
    }

    public boolean tick(IMultiblockContext<CokerUnitLogic.State> context, int chamberId) {
        if (this.rHolder == null) {
            return this.setStage(State.STANDBY);
        }
        CokerUnitLogic.State logicState = (CokerUnitLogic.State)context.getState();
        switch (this.state.ordinal()) {
            case 0: {
                if (this.rHolder == null) break;
                return this.setStage(State.PROCESSING);
            }
            case 1: {
                CokerUnitRecipe recipe = (CokerUnitRecipe)this.rHolder.value();
                if (this.inputAmount <= 0 || this.getInputItem().isEmpty() || this.tank.getCapacity() - this.tank.getFluidAmount() < recipe.getOutputFluid().getAmount() || logicState.energy.getEnergyStored() < recipe.getTotalProcessEnergy() / recipe.getTotalProcessTime()) break;
                logicState.energy.extractEnergy(recipe.getTotalProcessEnergy() / recipe.getTotalProcessTime(), false);
                ++this.timer;
                if (this.timer >= recipe.getTotalProcessTime() * recipe.getInputItem().getCount()) {
                    this.timer = 0;
                    this.tank.fill(recipe.getOutputFluid().copyWithAmount(recipe.getOutputFluid().getAmount()), IFluidHandler.FluidAction.EXECUTE);
                    --this.inputAmount;
                    ++this.outputAmount;
                    if (this.inputAmount <= 0) {
                        this.setStage(State.DRAIN_RESIDUE);
                    }
                }
                return true;
            }
            case 2: {
                if (this.tank.getFluidAmount() > 0) {
                    FluidStack drained;
                    FluidTankFiltered buffer = logicState.bufferTanks.output();
                    int accepted = buffer.fill(drained = this.tank.drain(25, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE);
                    if (accepted <= 0) break;
                    int amount = Math.min(drained.getAmount(), accepted);
                    this.tank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                    buffer.fill(drained.copyWithAmount(amount), IFluidHandler.FluidAction.EXECUTE);
                    return true;
                }
                return this.setStage(State.FLOODING);
            }
            case 3: {
                ++this.timer;
                if (this.timer < 2) break;
                this.timer = 0;
                CokerUnitRecipe recipe = (CokerUnitRecipe)this.rHolder.value();
                int max = this.getTotalAmount() * recipe.getInputFluid().amount();
                if (this.tank.getFluidAmount() < max) {
                    FluidStack accepted = logicState.bufferTanks.input().drain(recipe.getInputFluid().amount(), IFluidHandler.FluidAction.SIMULATE);
                    if (accepted.getAmount() < recipe.getInputFluid().amount()) break;
                    logicState.bufferTanks.input().drain(recipe.getInputFluid().amount(), IFluidHandler.FluidAction.EXECUTE);
                    this.tank.fill(accepted, IFluidHandler.FluidAction.EXECUTE);
                    break;
                }
                if (this.tank.getFluidAmount() < max) break;
                return this.setStage(State.DUMPING);
            }
            case 4: {
                boolean update = false;
                ++this.timer;
                if (this.timer >= 5) {
                    this.timer = 0;
                    if (this.outputAmount > 0) {
                        IMultiblockLevel multiLevel = context.getLevel();
                        Level world = multiLevel.getRawLevel();
                        int amount = Math.min(this.outputAmount, 1);
                        ItemStack copy = ((CokerUnitRecipe)this.rHolder.value()).getOutputItem();
                        copy.setCount(amount);
                        BlockPos itemOutPos = multiLevel.toAbsolute(chamberId == 0 ? CokerUnitLogic.Chamber_A_OUT.posInMultiblock() : CokerUnitLogic.Chamber_B_OUT.posInMultiblock());
                        Vec3 center = new Vec3((double)itemOutPos.getX() + 0.5, (double)itemOutPos.getY() - 0.5, (double)itemOutPos.getZ() + 0.5);
                        ItemEntity ent = new ItemEntity(world, center.x, center.y, center.z, copy);
                        ent.setDeltaMovement(0.0, 0.0, 0.0);
                        world.addFreshEntity((Entity)ent);
                        this.outputAmount -= amount;
                        update = true;
                    }
                }
                if (this.tank.getFluidAmount() > 0) {
                    this.tank.drain(25, IFluidHandler.FluidAction.EXECUTE);
                    update = true;
                }
                if (this.outputAmount <= 0 && this.tank.getFluid().isEmpty()) {
                    this.rHolder = null;
                    this.setStage(State.STANDBY);
                    update = true;
                }
                if (!update) break;
                return true;
            }
        }
        return false;
    }

    public static enum State {
        STANDBY,
        PROCESSING,
        DRAIN_RESIDUE,
        FLOODING,
        DUMPING;


        public int id() {
            return this.ordinal();
        }
    }
}

