/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.LayeredComparatorOutput;
import com.google.common.collect.ImmutableSet;
import flaxbeard.immersivepetroleum.common.ExternalModContent;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.multiblocks.shapes.OilTankShape;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.inventory.FluidTankFiltered;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class OilTankLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State>,
MBOverlayText<State> {
    public static final int EQUALIZING_THRESHOLD = 1;
    public static final BlockPos[] Redstone_IN = new BlockPos[]{new BlockPos(2, 2, 5), new BlockPos(2, 2, 2)};

    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    public void tickClient(IMultiblockContext<State> context) {
    }

    public void tickServer(IMultiblockContext<State> ctx) {
        State state = (State)ctx.getState();
        IMultiblockLevel level = ctx.getLevel();
        PortState portStateA = state.getPortStateFor(Port.DYNAMIC_A);
        PortState portStateB = state.getPortStateFor(Port.DYNAMIC_B);
        PortState portStateC = state.getPortStateFor(Port.DYNAMIC_C);
        PortState portStateD = state.getPortStateFor(Port.DYNAMIC_D);
        boolean wasBalancing = false;
        if (portStateA == PortState.OUTPUT && portStateC == PortState.INPUT || portStateA == PortState.INPUT && portStateC == PortState.OUTPUT) {
            wasBalancing |= state.equalize(ctx, Port.DYNAMIC_A, 1, 10000);
        }
        if (portStateB == PortState.OUTPUT && portStateD == PortState.INPUT || portStateB == PortState.INPUT && portStateD == PortState.OUTPUT) {
            wasBalancing |= state.equalize(ctx, Port.DYNAMIC_B, 1, 10000);
        }
        if (state.rsState.isEnabled(ctx) && state.tank.getFluidAmount() > 0) {
            for (Port port : Port.values()) {
                if (state.tank.getFluidAmount() == 0) break;
                if ((wasBalancing || state.getPortStateFor(port) != PortState.OUTPUT) && (!wasBalancing || port != Port.BOTTOM)) continue;
                Direction facing = state.getPortDirection(level.getOrientation(), port);
                BlockPos pos = level.toAbsolute(port.posInMultiblock.posInMultiblock()).relative(facing);
                FluidUtil.getFluidHandler((Level)level.getRawLevel(), (BlockPos)pos, (Direction)facing.getOpposite()).ifPresent(out -> {
                    FluidStack fs = FluidHelper.copyFluid(state.tank.getFluid(), Math.min(state.tank.getFluidAmount(), 432), false);
                    int accepted = out.fill(fs, IFluidHandler.FluidAction.SIMULATE);
                    if (accepted > 0) {
                        int drained = out.fill(FluidHelper.copyFluid(fs, Math.min(fs.getAmount(), accepted), false), IFluidHandler.FluidAction.EXECUTE);
                        state.tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
                    }
                });
            }
        }
        ctx.markDirtyAndSync();
        state.comparatorHelper.update(ctx, (double)state.tank.getFluidAmount());
    }

    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.register(Capabilities.FluidHandler.BLOCK, (state, position) -> {
            for (Port port : Port.values()) {
                if (!port.matches(position.posInMultiblock())) continue;
                return switch (state.portConfig.get((Object)port).ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> state.fluidInput;
                    case 1 -> state.fluidOutput;
                };
            }
            return null;
        });
    }

    public ItemInteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        if (ExternalModContent.IE.isHammer(player.getItemInHand(hand)) && this.hammering(ctx, posInMultiblock, isClient)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (FluidUtils.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)((State)ctx.getState()).tank)) {
            ctx.markDirtyAndSync();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean hammering(IMultiblockContext<State> ctx, BlockPos posInMultiblock, boolean isClient) {
        if (!isClient) {
            for (Port port : Port.DYNAMIC_PORTS) {
                if (!port.matches(posInMultiblock)) continue;
                ((State)ctx.getState()).togglePortState(port);
                ctx.markDirtyAndSync();
                return true;
            }
        }
        return false;
    }

    public List<Component> getOverlayText(State state, BlockPos posInMultiblock, BlockHitResult absoluteHit, Player player, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return List.of(TextUtils.formatFluidStack((FluidStack)state.tank.getFluid()));
        }
        return List.of();
    }

    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return OilTankShape.GETTER;
    }

    public static class State
    implements IMultiblockState {
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.disabledByDefault();
        public final FluidTankFiltered tank = new FluidTankFiltered(1024000, f -> !f.getFluid().getFluidType().isLighterThanAir());
        public final EnumMap<Port, PortState> portConfig = new EnumMap(Port.class);
        private final LayeredComparatorOutput<IMultiblockContext<?>> comparatorHelper;
        private final IFluidHandler fluidInput;
        private final IFluidHandler fluidOutput;

        public State(IInitialMultiblockContext<State> context) {
            BlockPos masterPos = IPContent.Multiblock.OILTANK.masterPosInMB();
            Updater update = (ctx, layer, value) -> {
                IMultiblockLevel level = ctx.getLevel();
                ctx.setComparatorOutputFor(layer, value);
                BlockPos absPos = level.toAbsolute(masterPos);
                BlockState stateAt = level.getBlockState(masterPos);
                level.getRawLevel().updateNeighborsAt(absPos, stateAt.getBlock());
            };
            this.comparatorHelper = new LayeredComparatorOutput((double)this.tank.getCapacity(), 3, (ctx, value) -> update.update((IMultiblockContext<?>)ctx, masterPos, value), (ctx, layer, value) -> {
                for (int z = -2; z <= 2; ++z) {
                    for (int x = -2; x <= 2; ++x) {
                        if (x == 0 && z == 0) continue;
                        BlockPos pos = masterPos.offset(x, layer, z);
                        update.update((IMultiblockContext<?>)ctx, pos, value);
                    }
                }
            });
            for (Port port : Port.values()) {
                if (port == Port.DYNAMIC_B || port == Port.DYNAMIC_C || port == Port.BOTTOM) {
                    this.portConfig.put(port, PortState.OUTPUT);
                    continue;
                }
                this.portConfig.put(port, PortState.INPUT);
            }
            this.fluidInput = ArrayFluidHandler.fillOnly((IFluidTank)this.tank, (Runnable)context.getMarkDirtyRunnable());
            this.fluidOutput = ArrayFluidHandler.drainOnly((IFluidTank)this.tank, (Runnable)context.getMarkDirtyRunnable());
        }

        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("tank", (Tag)this.tank.writeToNBT(new CompoundTag(), provider));
            for (Port port : Port.DYNAMIC_PORTS) {
                nbt.putInt(port.getSerializedName(), this.getPortStateFor(port).ordinal());
            }
            this.rsState.writeSaveNBT(nbt, provider);
        }

        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.tank.readFromNBT(nbt.getCompound("tank"), provider);
            for (Port port : Port.DYNAMIC_PORTS) {
                this.portConfig.put(port, PortState.values()[nbt.getInt(port.getSerializedName())]);
            }
            this.rsState.readSaveNBT(nbt, provider);
        }

        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.writeSaveNBT(nbt, provider);
        }

        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.readSaveNBT(nbt, provider);
        }

        public PortState getPortStateFor(Port port) {
            return this.portConfig.get((Object)port);
        }

        public void togglePortState(Port port) {
            this.portConfig.compute(port, (k, next) -> next.next());
        }

        private boolean equalize(IMultiblockContext<State> ctx, Port port, int threshold, int maxTransfer) {
            IMultiblockBE multiblockBE;
            IMultiblockLevel level = ctx.getLevel();
            Direction facing = this.getPortDirection(level.getOrientation(), port);
            BlockPos pos = level.toAbsolute(port.posInMultiblock.posInMultiblock()).relative(facing);
            BlockEntity te = level.getRawLevel().getBlockEntity(pos);
            if (te instanceof IMultiblockBE && (multiblockBE = (IMultiblockBE)te).getHelper().getContext().getState() instanceof State) {
                IMultiblockContext otherState = multiblockBE.getHelper().asType(IPContent.Multiblock.OILTANK).getContext();
                int diff = ((State)otherState.getState()).tank.getFluidAmount() - this.tank.getFluidAmount();
                int amount = Math.min(Math.abs(diff) / 2, maxTransfer);
                return diff <= -threshold && this.transfer(ctx, (IMultiblockContext<State>)otherState, amount) || diff >= threshold && this.transfer((IMultiblockContext<State>)otherState, ctx, amount);
            }
            return false;
        }

        private boolean transfer(IMultiblockContext<State> src, IMultiblockContext<State> dst, int amount) {
            State srcState = (State)src.getState();
            State dstState = (State)dst.getState();
            Holder fluid = srcState.tank.getFluid().getFluidHolder();
            FluidStack fs = new FluidStack(fluid, amount);
            int accepted = dstState.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE);
            if (accepted > 0) {
                fs = new FluidStack(fluid, accepted);
                dstState.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                srcState.tank.drain(fs, IFluidHandler.FluidAction.EXECUTE);
                src.markDirtyAndSync();
                dst.markDirtyAndSync();
                return true;
            }
            return false;
        }

        private Direction getPortDirection(MultiblockOrientation orientation, Port port) {
            boolean isMirrored = orientation.mirrored();
            Direction front = orientation.front();
            switch (port.ordinal()) {
                case 3: 
                case 5: {
                    return isMirrored ? front.getCounterClockWise() : front.getClockWise();
                }
                case 2: 
                case 4: {
                    return isMirrored ? front.getClockWise() : front.getCounterClockWise();
                }
                case 0: {
                    return Direction.UP;
                }
            }
            return Direction.DOWN;
        }

        static interface Updater {
            public void update(IMultiblockContext<?> var1, BlockPos var2, int var3);
        }
    }

    public static enum Port implements StringRepresentable
    {
        TOP(new CapabilityPosition(2, 2, 3, RelativeBlockFace.UP)),
        BOTTOM(new CapabilityPosition(2, 0, 3, RelativeBlockFace.DOWN)),
        DYNAMIC_A(new CapabilityPosition(0, 1, 2, RelativeBlockFace.RIGHT)),
        DYNAMIC_B(new CapabilityPosition(4, 1, 2, RelativeBlockFace.LEFT)),
        DYNAMIC_C(new CapabilityPosition(0, 1, 4, RelativeBlockFace.RIGHT)),
        DYNAMIC_D(new CapabilityPosition(4, 1, 4, RelativeBlockFace.LEFT));

        public static final Port[] DYNAMIC_PORTS;
        public final CapabilityPosition posInMultiblock;

        private Port(CapabilityPosition posInMultiblock) {
            this.posInMultiblock = posInMultiblock;
        }

        public boolean matches(BlockPos posInMultiblock) {
            return posInMultiblock.equals((Object)this.posInMultiblock.posInMultiblock());
        }

        @Nonnull
        public String getSerializedName() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        static Set<CapabilityPosition> toSet(Port ... ports) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Port port : ports) {
                builder.add((Object)port.posInMultiblock);
            }
            return builder.build();
        }

        static {
            DYNAMIC_PORTS = new Port[]{DYNAMIC_A, DYNAMIC_B, DYNAMIC_C, DYNAMIC_D};
        }
    }

    public static enum PortState implements StringRepresentable
    {
        INPUT,
        OUTPUT;


        @Nonnull
        public String getSerializedName() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        public Component getText() {
            return Component.translatable((String)("desc.immersivepetroleum.info.oiltank." + this.getSerializedName()));
        }

        public PortState next() {
            return this == INPUT ? OUTPUT : INPUT;
        }
    }
}

